package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectFieldSelectorBuilder extends ObjectFieldSelectorFluentImpl<ObjectFieldSelectorBuilder> implements VisitableBuilder<ObjectFieldSelector,ObjectFieldSelectorBuilder>{
  public ObjectFieldSelectorBuilder() {
    this(false);
  }
  public ObjectFieldSelectorBuilder(Boolean validationEnabled) {
    this(new ObjectFieldSelector(), validationEnabled);
  }
  public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObjectFieldSelector(), validationEnabled);
  }
  public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent,ObjectFieldSelector instance) {
    this(fluent, instance, false);
  }
  public ObjectFieldSelectorBuilder(ObjectFieldSelectorFluent<?> fluent,ObjectFieldSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withFieldPath(instance.getFieldPath()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ObjectFieldSelectorBuilder(ObjectFieldSelector instance) {
    this(instance,false);
  }
  public ObjectFieldSelectorBuilder(ObjectFieldSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withFieldPath(instance.getFieldPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ObjectFieldSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public ObjectFieldSelector build() {
    ObjectFieldSelector buildable = new ObjectFieldSelector(fluent.getApiVersion(),fluent.getFieldPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}