package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class QuobyteVolumeSourceBuilder extends QuobyteVolumeSourceFluentImpl<QuobyteVolumeSourceBuilder> implements VisitableBuilder<QuobyteVolumeSource,QuobyteVolumeSourceBuilder>{
  public QuobyteVolumeSourceBuilder() {
    this(false);
  }
  public QuobyteVolumeSourceBuilder(Boolean validationEnabled) {
    this(new QuobyteVolumeSource(), validationEnabled);
  }
  public QuobyteVolumeSourceBuilder(QuobyteVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public QuobyteVolumeSourceBuilder(QuobyteVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new QuobyteVolumeSource(), validationEnabled);
  }
  public QuobyteVolumeSourceBuilder(QuobyteVolumeSourceFluent<?> fluent,QuobyteVolumeSource instance) {
    this(fluent, instance, false);
  }
  public QuobyteVolumeSourceBuilder(QuobyteVolumeSourceFluent<?> fluent,QuobyteVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withRegistry(instance.getRegistry()); 
    fluent.withTenant(instance.getTenant()); 
    fluent.withUser(instance.getUser()); 
    fluent.withVolume(instance.getVolume()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public QuobyteVolumeSourceBuilder(QuobyteVolumeSource instance) {
    this(instance,false);
  }
  public QuobyteVolumeSourceBuilder(QuobyteVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withRegistry(instance.getRegistry()); 
    this.withTenant(instance.getTenant()); 
    this.withUser(instance.getUser()); 
    this.withVolume(instance.getVolume()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  QuobyteVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public QuobyteVolumeSource build() {
    QuobyteVolumeSource buildable = new QuobyteVolumeSource(fluent.getGroup(),fluent.getReadOnly(),fluent.getRegistry(),fluent.getTenant(),fluent.getUser(),fluent.getVolume());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}