package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ReplicationControllerListFluent<A extends ReplicationControllerListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,ReplicationController item);
  public A setToItems(Integer index,ReplicationController item);
  public A addToItems(io.fabric8.kubernetes.api.model.ReplicationController... items);
  public A addAllToItems(Collection<ReplicationController> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.ReplicationController... items);
  public A removeAllFromItems(Collection<ReplicationController> items);
  public A removeMatchingFromItems(Predicate<ReplicationControllerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ReplicationController> getItems();
  public List<ReplicationController> buildItems();
  public ReplicationController buildItem(Integer index);
  public ReplicationController buildFirstItem();
  public ReplicationController buildLastItem();
  public ReplicationController buildMatchingItem(Predicate<ReplicationControllerBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ReplicationControllerBuilder> predicate);
  public A withItems(List<ReplicationController> items);
  public A withItems(io.fabric8.kubernetes.api.model.ReplicationController... items);
  public Boolean hasItems();
  public ReplicationControllerListFluent.ItemsNested<A> addNewItem();
  public ReplicationControllerListFluent.ItemsNested<A> addNewItemLike(ReplicationController item);
  public ReplicationControllerListFluent.ItemsNested<A> setNewItemLike(Integer index,ReplicationController item);
  public ReplicationControllerListFluent.ItemsNested<A> editItem(Integer index);
  public ReplicationControllerListFluent.ItemsNested<A> editFirstItem();
  public ReplicationControllerListFluent.ItemsNested<A> editLastItem();
  public ReplicationControllerListFluent.ItemsNested<A> editMatchingItem(Predicate<ReplicationControllerBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public ReplicationControllerListFluent.MetadataNested<A> withNewMetadata();
  public ReplicationControllerListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public ReplicationControllerListFluent.MetadataNested<A> editMetadata();
  public ReplicationControllerListFluent.MetadataNested<A> editOrNewMetadata();
  public ReplicationControllerListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ReplicationControllerFluent<ReplicationControllerListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ReplicationControllerListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}