package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceAccountFluent<A extends ServiceAccountFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public Boolean getAutomountServiceAccountToken();
  public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken);
  public Boolean hasAutomountServiceAccountToken();
  public A addToImagePullSecrets(Integer index,LocalObjectReference item);
  public A setToImagePullSecrets(Integer index,LocalObjectReference item);
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets();
  public List<LocalObjectReference> buildImagePullSecrets();
  public LocalObjectReference buildImagePullSecret(Integer index);
  public LocalObjectReference buildFirstImagePullSecret();
  public LocalObjectReference buildLastImagePullSecret();
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets);
  public Boolean hasImagePullSecrets();
  public A addNewImagePullSecret(String name);
  public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
  public ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
  public ServiceAccountFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(Integer index,LocalObjectReference item);
  public ServiceAccountFluent.ImagePullSecretsNested<A> editImagePullSecret(Integer index);
  public ServiceAccountFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
  public ServiceAccountFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
  public ServiceAccountFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public ServiceAccountFluent.MetadataNested<A> withNewMetadata();
  public ServiceAccountFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public ServiceAccountFluent.MetadataNested<A> editMetadata();
  public ServiceAccountFluent.MetadataNested<A> editOrNewMetadata();
  public ServiceAccountFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToSecrets(Integer index,ObjectReference item);
  public A setToSecrets(Integer index,ObjectReference item);
  public A addToSecrets(io.fabric8.kubernetes.api.model.ObjectReference... items);
  public A addAllToSecrets(Collection<ObjectReference> items);
  public A removeFromSecrets(io.fabric8.kubernetes.api.model.ObjectReference... items);
  public A removeAllFromSecrets(Collection<ObjectReference> items);
  public A removeMatchingFromSecrets(Predicate<ObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ObjectReference> getSecrets();
  public List<ObjectReference> buildSecrets();
  public ObjectReference buildSecret(Integer index);
  public ObjectReference buildFirstSecret();
  public ObjectReference buildLastSecret();
  public ObjectReference buildMatchingSecret(Predicate<ObjectReferenceBuilder> predicate);
  public Boolean hasMatchingSecret(Predicate<ObjectReferenceBuilder> predicate);
  public A withSecrets(List<ObjectReference> secrets);
  public A withSecrets(io.fabric8.kubernetes.api.model.ObjectReference... secrets);
  public Boolean hasSecrets();
  public ServiceAccountFluent.SecretsNested<A> addNewSecret();
  public ServiceAccountFluent.SecretsNested<A> addNewSecretLike(ObjectReference item);
  public ServiceAccountFluent.SecretsNested<A> setNewSecretLike(Integer index,ObjectReference item);
  public ServiceAccountFluent.SecretsNested<A> editSecret(Integer index);
  public ServiceAccountFluent.SecretsNested<A> editFirstSecret();
  public ServiceAccountFluent.SecretsNested<A> editLastSecret();
  public ServiceAccountFluent.SecretsNested<A> editMatchingSecret(Predicate<ObjectReferenceBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAutomountServiceAccountToken();
  public interface ImagePullSecretsNested<N> extends Nested<N>,LocalObjectReferenceFluent<ServiceAccountFluent.ImagePullSecretsNested<N>>{
    public N and();
    public N endImagePullSecret();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ServiceAccountFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SecretsNested<N> extends Nested<N>,ObjectReferenceFluent<ServiceAccountFluent.SecretsNested<N>>{
    public N and();
    public N endSecret();
    
  }
  
}