package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface APIGroupListFluent<A extends APIGroupListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToGroups(Integer index,APIGroup item);
  public A setToGroups(Integer index,APIGroup item);
  public A addToGroups(io.fabric8.kubernetes.api.model.APIGroup... items);
  public A addAllToGroups(Collection<APIGroup> items);
  public A removeFromGroups(io.fabric8.kubernetes.api.model.APIGroup... items);
  public A removeAllFromGroups(Collection<APIGroup> items);
  public A removeMatchingFromGroups(Predicate<APIGroupBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildGroups instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<APIGroup> getGroups();
  public List<APIGroup> buildGroups();
  public APIGroup buildGroup(Integer index);
  public APIGroup buildFirstGroup();
  public APIGroup buildLastGroup();
  public APIGroup buildMatchingGroup(Predicate<APIGroupBuilder> predicate);
  public Boolean hasMatchingGroup(Predicate<APIGroupBuilder> predicate);
  public A withGroups(List<APIGroup> groups);
  public A withGroups(io.fabric8.kubernetes.api.model.APIGroup... groups);
  public Boolean hasGroups();
  public APIGroupListFluent.GroupsNested<A> addNewGroup();
  public APIGroupListFluent.GroupsNested<A> addNewGroupLike(APIGroup item);
  public APIGroupListFluent.GroupsNested<A> setNewGroupLike(Integer index,APIGroup item);
  public APIGroupListFluent.GroupsNested<A> editGroup(Integer index);
  public APIGroupListFluent.GroupsNested<A> editFirstGroup();
  public APIGroupListFluent.GroupsNested<A> editLastGroup();
  public APIGroupListFluent.GroupsNested<A> editMatchingGroup(Predicate<APIGroupBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface GroupsNested<N> extends Nested<N>,APIGroupFluent<APIGroupListFluent.GroupsNested<N>>{
    public N and();
    public N endGroup();
    
  }
  
}