package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface APIResourceListFluent<A extends APIResourceListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getGroupVersion();
  public A withGroupVersion(String groupVersion);
  public Boolean hasGroupVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public A addToResources(Integer index,APIResource item);
  public A setToResources(Integer index,APIResource item);
  public A addToResources(io.fabric8.kubernetes.api.model.APIResource... items);
  public A addAllToResources(Collection<APIResource> items);
  public A removeFromResources(io.fabric8.kubernetes.api.model.APIResource... items);
  public A removeAllFromResources(Collection<APIResource> items);
  public A removeMatchingFromResources(Predicate<APIResourceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<APIResource> getResources();
  public List<APIResource> buildResources();
  public APIResource buildResource(Integer index);
  public APIResource buildFirstResource();
  public APIResource buildLastResource();
  public APIResource buildMatchingResource(Predicate<APIResourceBuilder> predicate);
  public Boolean hasMatchingResource(Predicate<APIResourceBuilder> predicate);
  public A withResources(List<APIResource> resources);
  public A withResources(io.fabric8.kubernetes.api.model.APIResource... resources);
  public Boolean hasResources();
  public APIResourceListFluent.ResourcesNested<A> addNewResource();
  public APIResourceListFluent.ResourcesNested<A> addNewResourceLike(APIResource item);
  public APIResourceListFluent.ResourcesNested<A> setNewResourceLike(Integer index,APIResource item);
  public APIResourceListFluent.ResourcesNested<A> editResource(Integer index);
  public APIResourceListFluent.ResourcesNested<A> editFirstResource();
  public APIResourceListFluent.ResourcesNested<A> editLastResource();
  public APIResourceListFluent.ResourcesNested<A> editMatchingResource(Predicate<APIResourceBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ResourcesNested<N> extends Nested<N>,APIResourceFluent<APIResourceListFluent.ResourcesNested<N>>{
    public N and();
    public N endResource();
    
  }
  
}