package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CapabilitiesBuilder extends CapabilitiesFluentImpl<CapabilitiesBuilder> implements VisitableBuilder<Capabilities,CapabilitiesBuilder>{
  public CapabilitiesBuilder() {
    this(false);
  }
  public CapabilitiesBuilder(Boolean validationEnabled) {
    this(new Capabilities(), validationEnabled);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent) {
    this(fluent, false);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Capabilities(), validationEnabled);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Capabilities instance) {
    this(fluent, instance, false);
  }
  public CapabilitiesBuilder(CapabilitiesFluent<?> fluent,Capabilities instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdd(instance.getAdd()); 
    fluent.withDrop(instance.getDrop()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CapabilitiesBuilder(Capabilities instance) {
    this(instance,false);
  }
  public CapabilitiesBuilder(Capabilities instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdd(instance.getAdd()); 
    this.withDrop(instance.getDrop()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CapabilitiesFluent<?> fluent;
  Boolean validationEnabled;
  public Capabilities build() {
    Capabilities buildable = new Capabilities(fluent.getAdd(),fluent.getDrop());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}