package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface CephFSPersistentVolumeSourceFluent<A extends CephFSPersistentVolumeSourceFluent<A>> extends Fluent<A>{
  public A addToMonitors(Integer index,String item);
  public A setToMonitors(Integer index,String item);
  public A addToMonitors(java.lang.String... items);
  public A addAllToMonitors(Collection<String> items);
  public A removeFromMonitors(java.lang.String... items);
  public A removeAllFromMonitors(Collection<String> items);
  public List<String> getMonitors();
  public String getMonitor(Integer index);
  public String getFirstMonitor();
  public String getLastMonitor();
  public String getMatchingMonitor(Predicate<String> predicate);
  public Boolean hasMatchingMonitor(Predicate<String> predicate);
  public A withMonitors(List<String> monitors);
  public A withMonitors(java.lang.String... monitors);
  public Boolean hasMonitors();
  public String getPath();
  public A withPath(String path);
  public Boolean hasPath();
  public Boolean getReadOnly();
  public A withReadOnly(Boolean readOnly);
  public Boolean hasReadOnly();
  public String getSecretFile();
  public A withSecretFile(String secretFile);
  public Boolean hasSecretFile();
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretReference getSecretRef();
  public SecretReference buildSecretRef();
  public A withSecretRef(SecretReference secretRef);
  public Boolean hasSecretRef();
  public A withNewSecretRef(String name,String namespace);
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(SecretReference item);
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef();
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef();
  public CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretReference item);
  public String getUser();
  public A withUser(String user);
  public Boolean hasUser();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withReadOnly();
  public interface SecretRefNested<N> extends Nested<N>,SecretReferenceFluent<CephFSPersistentVolumeSourceFluent.SecretRefNested<N>>{
    public N and();
    public N endSecretRef();
    
  }
  
}