package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
public interface PodSpecFluent<A extends PodSpecFluent<A>> extends Fluent<A>{
  public Long getActiveDeadlineSeconds();
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
  public Boolean hasActiveDeadlineSeconds();
  
  /**
   * This method has been deprecated, please use method buildAffinity instead.
   * @return The buildable object.
   */
  @Deprecated
  public Affinity getAffinity();
  public Affinity buildAffinity();
  public A withAffinity(Affinity affinity);
  public Boolean hasAffinity();
  public PodSpecFluent.AffinityNested<A> withNewAffinity();
  public PodSpecFluent.AffinityNested<A> withNewAffinityLike(Affinity item);
  public PodSpecFluent.AffinityNested<A> editAffinity();
  public PodSpecFluent.AffinityNested<A> editOrNewAffinity();
  public PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(Affinity item);
  public Boolean getAutomountServiceAccountToken();
  public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken);
  public Boolean hasAutomountServiceAccountToken();
  public A addToContainers(Integer index,Container item);
  public A setToContainers(Integer index,Container item);
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToContainers(Collection<Container> items);
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromContainers(Collection<Container> items);
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers();
  public List<Container> buildContainers();
  public Container buildContainer(Integer index);
  public Container buildFirstContainer();
  public Container buildLastContainer();
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate);
  public A withContainers(List<Container> containers);
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers);
  public Boolean hasContainers();
  public PodSpecFluent.ContainersNested<A> addNewContainer();
  public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item);
  public PodSpecFluent.ContainersNested<A> setNewContainerLike(Integer index,Container item);
  public PodSpecFluent.ContainersNested<A> editContainer(Integer index);
  public PodSpecFluent.ContainersNested<A> editFirstContainer();
  public PodSpecFluent.ContainersNested<A> editLastContainer();
  public PodSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDnsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodDNSConfig getDnsConfig();
  public PodDNSConfig buildDnsConfig();
  public A withDnsConfig(PodDNSConfig dnsConfig);
  public Boolean hasDnsConfig();
  public PodSpecFluent.DnsConfigNested<A> withNewDnsConfig();
  public PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(PodDNSConfig item);
  public PodSpecFluent.DnsConfigNested<A> editDnsConfig();
  public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig();
  public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(PodDNSConfig item);
  public String getDnsPolicy();
  public A withDnsPolicy(String dnsPolicy);
  public Boolean hasDnsPolicy();
  public Boolean getEnableServiceLinks();
  public A withEnableServiceLinks(Boolean enableServiceLinks);
  public Boolean hasEnableServiceLinks();
  public A addToEphemeralContainers(Integer index,EphemeralContainer item);
  public A setToEphemeralContainers(Integer index,EphemeralContainer item);
  public A addToEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items);
  public A addAllToEphemeralContainers(Collection<EphemeralContainer> items);
  public A removeFromEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items);
  public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items);
  public A removeMatchingFromEphemeralContainers(Predicate<EphemeralContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildEphemeralContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EphemeralContainer> getEphemeralContainers();
  public List<EphemeralContainer> buildEphemeralContainers();
  public EphemeralContainer buildEphemeralContainer(Integer index);
  public EphemeralContainer buildFirstEphemeralContainer();
  public EphemeralContainer buildLastEphemeralContainer();
  public EphemeralContainer buildMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate);
  public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate);
  public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers);
  public A withEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... ephemeralContainers);
  public Boolean hasEphemeralContainers();
  public PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainer();
  public PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainerLike(EphemeralContainer item);
  public PodSpecFluent.EphemeralContainersNested<A> setNewEphemeralContainerLike(Integer index,EphemeralContainer item);
  public PodSpecFluent.EphemeralContainersNested<A> editEphemeralContainer(Integer index);
  public PodSpecFluent.EphemeralContainersNested<A> editFirstEphemeralContainer();
  public PodSpecFluent.EphemeralContainersNested<A> editLastEphemeralContainer();
  public PodSpecFluent.EphemeralContainersNested<A> editMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate);
  public A addToHostAliases(Integer index,HostAlias item);
  public A setToHostAliases(Integer index,HostAlias item);
  public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
  public A addAllToHostAliases(Collection<HostAlias> items);
  public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
  public A removeAllFromHostAliases(Collection<HostAlias> items);
  public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildHostAliases instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HostAlias> getHostAliases();
  public List<HostAlias> buildHostAliases();
  public HostAlias buildHostAlias(Integer index);
  public HostAlias buildFirstHostAlias();
  public HostAlias buildLastHostAlias();
  public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate);
  public Boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate);
  public A withHostAliases(List<HostAlias> hostAliases);
  public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases);
  public Boolean hasHostAliases();
  public PodSpecFluent.HostAliasesNested<A> addNewHostAlias();
  public PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(HostAlias item);
  public PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(Integer index,HostAlias item);
  public PodSpecFluent.HostAliasesNested<A> editHostAlias(Integer index);
  public PodSpecFluent.HostAliasesNested<A> editFirstHostAlias();
  public PodSpecFluent.HostAliasesNested<A> editLastHostAlias();
  public PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate);
  public Boolean getHostIPC();
  public A withHostIPC(Boolean hostIPC);
  public Boolean hasHostIPC();
  public Boolean getHostNetwork();
  public A withHostNetwork(Boolean hostNetwork);
  public Boolean hasHostNetwork();
  public Boolean getHostPID();
  public A withHostPID(Boolean hostPID);
  public Boolean hasHostPID();
  public Boolean getHostUsers();
  public A withHostUsers(Boolean hostUsers);
  public Boolean hasHostUsers();
  public String getHostname();
  public A withHostname(String hostname);
  public Boolean hasHostname();
  public A addToImagePullSecrets(Integer index,LocalObjectReference item);
  public A setToImagePullSecrets(Integer index,LocalObjectReference item);
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items);
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets();
  public List<LocalObjectReference> buildImagePullSecrets();
  public LocalObjectReference buildImagePullSecret(Integer index);
  public LocalObjectReference buildFirstImagePullSecret();
  public LocalObjectReference buildLastImagePullSecret();
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets);
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets);
  public Boolean hasImagePullSecrets();
  public A addNewImagePullSecret(String name);
  public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
  public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item);
  public PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(Integer index,LocalObjectReference item);
  public PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(Integer index);
  public PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
  public PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
  public PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate);
  public A addToInitContainers(Integer index,Container item);
  public A setToInitContainers(Integer index,Container item);
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A addAllToInitContainers(Collection<Container> items);
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items);
  public A removeAllFromInitContainers(Collection<Container> items);
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers();
  public List<Container> buildInitContainers();
  public Container buildInitContainer(Integer index);
  public Container buildFirstInitContainer();
  public Container buildLastInitContainer();
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public A withInitContainers(List<Container> initContainers);
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers);
  public Boolean hasInitContainers();
  public PodSpecFluent.InitContainersNested<A> addNewInitContainer();
  public PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
  public PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item);
  public PodSpecFluent.InitContainersNested<A> editInitContainer(Integer index);
  public PodSpecFluent.InitContainersNested<A> editFirstInitContainer();
  public PodSpecFluent.InitContainersNested<A> editLastInitContainer();
  public PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public String getNodeName();
  public A withNodeName(String nodeName);
  public Boolean hasNodeName();
  public A addToNodeSelector(String key,String value);
  public A addToNodeSelector(Map<String,String> map);
  public A removeFromNodeSelector(String key);
  public A removeFromNodeSelector(Map<String,String> map);
  public Map<String,String> getNodeSelector();
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector);
  public Boolean hasNodeSelector();
  
  /**
   * This method has been deprecated, please use method buildOs instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodOS getOs();
  public PodOS buildOs();
  public A withOs(PodOS os);
  public Boolean hasOs();
  public A withNewOs(String name);
  public PodSpecFluent.OsNested<A> withNewOs();
  public PodSpecFluent.OsNested<A> withNewOsLike(PodOS item);
  public PodSpecFluent.OsNested<A> editOs();
  public PodSpecFluent.OsNested<A> editOrNewOs();
  public PodSpecFluent.OsNested<A> editOrNewOsLike(PodOS item);
  public A addToOverhead(String key,Quantity value);
  public A addToOverhead(Map<String,Quantity> map);
  public A removeFromOverhead(String key);
  public A removeFromOverhead(Map<String,Quantity> map);
  public Map<String,Quantity> getOverhead();
  public <K,V>A withOverhead(Map<String,Quantity> overhead);
  public Boolean hasOverhead();
  public String getPreemptionPolicy();
  public A withPreemptionPolicy(String preemptionPolicy);
  public Boolean hasPreemptionPolicy();
  public Integer getPriority();
  public A withPriority(Integer priority);
  public Boolean hasPriority();
  public String getPriorityClassName();
  public A withPriorityClassName(String priorityClassName);
  public Boolean hasPriorityClassName();
  public A addToReadinessGates(Integer index,PodReadinessGate item);
  public A setToReadinessGates(Integer index,PodReadinessGate item);
  public A addToReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items);
  public A addAllToReadinessGates(Collection<PodReadinessGate> items);
  public A removeFromReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items);
  public A removeAllFromReadinessGates(Collection<PodReadinessGate> items);
  public A removeMatchingFromReadinessGates(Predicate<PodReadinessGateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildReadinessGates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodReadinessGate> getReadinessGates();
  public List<PodReadinessGate> buildReadinessGates();
  public PodReadinessGate buildReadinessGate(Integer index);
  public PodReadinessGate buildFirstReadinessGate();
  public PodReadinessGate buildLastReadinessGate();
  public PodReadinessGate buildMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate);
  public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate);
  public A withReadinessGates(List<PodReadinessGate> readinessGates);
  public A withReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... readinessGates);
  public Boolean hasReadinessGates();
  public A addNewReadinessGate(String conditionType);
  public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate();
  public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(PodReadinessGate item);
  public PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(Integer index,PodReadinessGate item);
  public PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(Integer index);
  public PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate();
  public PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate();
  public PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate);
  public A addToResourceClaims(Integer index,PodResourceClaim item);
  public A setToResourceClaims(Integer index,PodResourceClaim item);
  public A addToResourceClaims(io.fabric8.kubernetes.api.model.PodResourceClaim... items);
  public A addAllToResourceClaims(Collection<PodResourceClaim> items);
  public A removeFromResourceClaims(io.fabric8.kubernetes.api.model.PodResourceClaim... items);
  public A removeAllFromResourceClaims(Collection<PodResourceClaim> items);
  public A removeMatchingFromResourceClaims(Predicate<PodResourceClaimBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildResourceClaims instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodResourceClaim> getResourceClaims();
  public List<PodResourceClaim> buildResourceClaims();
  public PodResourceClaim buildResourceClaim(Integer index);
  public PodResourceClaim buildFirstResourceClaim();
  public PodResourceClaim buildLastResourceClaim();
  public PodResourceClaim buildMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate);
  public Boolean hasMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate);
  public A withResourceClaims(List<PodResourceClaim> resourceClaims);
  public A withResourceClaims(io.fabric8.kubernetes.api.model.PodResourceClaim... resourceClaims);
  public Boolean hasResourceClaims();
  public PodSpecFluent.ResourceClaimsNested<A> addNewResourceClaim();
  public PodSpecFluent.ResourceClaimsNested<A> addNewResourceClaimLike(PodResourceClaim item);
  public PodSpecFluent.ResourceClaimsNested<A> setNewResourceClaimLike(Integer index,PodResourceClaim item);
  public PodSpecFluent.ResourceClaimsNested<A> editResourceClaim(Integer index);
  public PodSpecFluent.ResourceClaimsNested<A> editFirstResourceClaim();
  public PodSpecFluent.ResourceClaimsNested<A> editLastResourceClaim();
  public PodSpecFluent.ResourceClaimsNested<A> editMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate);
  public String getRestartPolicy();
  public A withRestartPolicy(String restartPolicy);
  public Boolean hasRestartPolicy();
  public String getRuntimeClassName();
  public A withRuntimeClassName(String runtimeClassName);
  public Boolean hasRuntimeClassName();
  public String getSchedulerName();
  public A withSchedulerName(String schedulerName);
  public Boolean hasSchedulerName();
  public A addToSchedulingGates(Integer index,PodSchedulingGate item);
  public A setToSchedulingGates(Integer index,PodSchedulingGate item);
  public A addToSchedulingGates(io.fabric8.kubernetes.api.model.PodSchedulingGate... items);
  public A addAllToSchedulingGates(Collection<PodSchedulingGate> items);
  public A removeFromSchedulingGates(io.fabric8.kubernetes.api.model.PodSchedulingGate... items);
  public A removeAllFromSchedulingGates(Collection<PodSchedulingGate> items);
  public A removeMatchingFromSchedulingGates(Predicate<PodSchedulingGateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSchedulingGates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodSchedulingGate> getSchedulingGates();
  public List<PodSchedulingGate> buildSchedulingGates();
  public PodSchedulingGate buildSchedulingGate(Integer index);
  public PodSchedulingGate buildFirstSchedulingGate();
  public PodSchedulingGate buildLastSchedulingGate();
  public PodSchedulingGate buildMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate);
  public Boolean hasMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate);
  public A withSchedulingGates(List<PodSchedulingGate> schedulingGates);
  public A withSchedulingGates(io.fabric8.kubernetes.api.model.PodSchedulingGate... schedulingGates);
  public Boolean hasSchedulingGates();
  public A addNewSchedulingGate(String name);
  public PodSpecFluent.SchedulingGatesNested<A> addNewSchedulingGate();
  public PodSpecFluent.SchedulingGatesNested<A> addNewSchedulingGateLike(PodSchedulingGate item);
  public PodSpecFluent.SchedulingGatesNested<A> setNewSchedulingGateLike(Integer index,PodSchedulingGate item);
  public PodSpecFluent.SchedulingGatesNested<A> editSchedulingGate(Integer index);
  public PodSpecFluent.SchedulingGatesNested<A> editFirstSchedulingGate();
  public PodSpecFluent.SchedulingGatesNested<A> editLastSchedulingGate();
  public PodSpecFluent.SchedulingGatesNested<A> editMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSecurityContext instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSecurityContext getSecurityContext();
  public PodSecurityContext buildSecurityContext();
  public A withSecurityContext(PodSecurityContext securityContext);
  public Boolean hasSecurityContext();
  public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext();
  public PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item);
  public PodSpecFluent.SecurityContextNested<A> editSecurityContext();
  public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext();
  public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(PodSecurityContext item);
  public String getServiceAccount();
  public A withServiceAccount(String serviceAccount);
  public Boolean hasServiceAccount();
  public String getServiceAccountName();
  public A withServiceAccountName(String serviceAccountName);
  public Boolean hasServiceAccountName();
  public Boolean getSetHostnameAsFQDN();
  public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN);
  public Boolean hasSetHostnameAsFQDN();
  public Boolean getShareProcessNamespace();
  public A withShareProcessNamespace(Boolean shareProcessNamespace);
  public Boolean hasShareProcessNamespace();
  public String getSubdomain();
  public A withSubdomain(String subdomain);
  public Boolean hasSubdomain();
  public Long getTerminationGracePeriodSeconds();
  public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds);
  public Boolean hasTerminationGracePeriodSeconds();
  public A addToTolerations(Integer index,Toleration item);
  public A setToTolerations(Integer index,Toleration item);
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A addAllToTolerations(Collection<Toleration> items);
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
  public A removeAllFromTolerations(Collection<Toleration> items);
  public A removeMatchingFromTolerations(Predicate<TolerationBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTolerations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Toleration> getTolerations();
  public List<Toleration> buildTolerations();
  public Toleration buildToleration(Integer index);
  public Toleration buildFirstToleration();
  public Toleration buildLastToleration();
  public Toleration buildMatchingToleration(Predicate<TolerationBuilder> predicate);
  public Boolean hasMatchingToleration(Predicate<TolerationBuilder> predicate);
  public A withTolerations(List<Toleration> tolerations);
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations);
  public Boolean hasTolerations();
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
  public PodSpecFluent.TolerationsNested<A> addNewToleration();
  public PodSpecFluent.TolerationsNested<A> addNewTolerationLike(Toleration item);
  public PodSpecFluent.TolerationsNested<A> setNewTolerationLike(Integer index,Toleration item);
  public PodSpecFluent.TolerationsNested<A> editToleration(Integer index);
  public PodSpecFluent.TolerationsNested<A> editFirstToleration();
  public PodSpecFluent.TolerationsNested<A> editLastToleration();
  public PodSpecFluent.TolerationsNested<A> editMatchingToleration(Predicate<TolerationBuilder> predicate);
  public A addToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item);
  public A setToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item);
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items);
  public A removeMatchingFromTopologySpreadConstraints(Predicate<TopologySpreadConstraintBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildTopologySpreadConstraints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TopologySpreadConstraint> getTopologySpreadConstraints();
  public List<TopologySpreadConstraint> buildTopologySpreadConstraints();
  public TopologySpreadConstraint buildTopologySpreadConstraint(Integer index);
  public TopologySpreadConstraint buildFirstTopologySpreadConstraint();
  public TopologySpreadConstraint buildLastTopologySpreadConstraint();
  public TopologySpreadConstraint buildMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate);
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate);
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints);
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints);
  public Boolean hasTopologySpreadConstraints();
  public PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint();
  public PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(TopologySpreadConstraint item);
  public PodSpecFluent.TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(Integer index,TopologySpreadConstraint item);
  public PodSpecFluent.TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(Integer index);
  public PodSpecFluent.TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint();
  public PodSpecFluent.TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint();
  public PodSpecFluent.TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate);
  public A addToVolumes(Integer index,Volume item);
  public A setToVolumes(Integer index,Volume item);
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A addAllToVolumes(Collection<Volume> items);
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items);
  public A removeAllFromVolumes(Collection<Volume> items);
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Volume> getVolumes();
  public List<Volume> buildVolumes();
  public Volume buildVolume(Integer index);
  public Volume buildFirstVolume();
  public Volume buildLastVolume();
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate);
  public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate);
  public A withVolumes(List<Volume> volumes);
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes);
  public Boolean hasVolumes();
  public PodSpecFluent.VolumesNested<A> addNewVolume();
  public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item);
  public PodSpecFluent.VolumesNested<A> setNewVolumeLike(Integer index,Volume item);
  public PodSpecFluent.VolumesNested<A> editVolume(Integer index);
  public PodSpecFluent.VolumesNested<A> editFirstVolume();
  public PodSpecFluent.VolumesNested<A> editLastVolume();
  public PodSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAutomountServiceAccountToken();
  public A withEnableServiceLinks();
  public A withHostIPC();
  public A withHostNetwork();
  public A withHostPID();
  public A withHostUsers();
  public A withSetHostnameAsFQDN();
  public A withShareProcessNamespace();
  public interface AffinityNested<N> extends Nested<N>,AffinityFluent<PodSpecFluent.AffinityNested<N>>{
    public N and();
    public N endAffinity();
    
  }
  public interface ContainersNested<N> extends Nested<N>,ContainerFluent<PodSpecFluent.ContainersNested<N>>{
    public N and();
    public N endContainer();
    
  }
  public interface DnsConfigNested<N> extends Nested<N>,PodDNSConfigFluent<PodSpecFluent.DnsConfigNested<N>>{
    public N and();
    public N endDnsConfig();
    
  }
  public interface EphemeralContainersNested<N> extends Nested<N>,EphemeralContainerFluent<PodSpecFluent.EphemeralContainersNested<N>>{
    public N and();
    public N endEphemeralContainer();
    
  }
  public interface HostAliasesNested<N> extends Nested<N>,HostAliasFluent<PodSpecFluent.HostAliasesNested<N>>{
    public N and();
    public N endHostAlias();
    
  }
  public interface ImagePullSecretsNested<N> extends Nested<N>,LocalObjectReferenceFluent<PodSpecFluent.ImagePullSecretsNested<N>>{
    public N and();
    public N endImagePullSecret();
    
  }
  public interface InitContainersNested<N> extends Nested<N>,ContainerFluent<PodSpecFluent.InitContainersNested<N>>{
    public N and();
    public N endInitContainer();
    
  }
  public interface OsNested<N> extends Nested<N>,PodOSFluent<PodSpecFluent.OsNested<N>>{
    public N and();
    public N endOs();
    
  }
  public interface ReadinessGatesNested<N> extends Nested<N>,PodReadinessGateFluent<PodSpecFluent.ReadinessGatesNested<N>>{
    public N and();
    public N endReadinessGate();
    
  }
  public interface ResourceClaimsNested<N> extends Nested<N>,PodResourceClaimFluent<PodSpecFluent.ResourceClaimsNested<N>>{
    public N and();
    public N endResourceClaim();
    
  }
  public interface SchedulingGatesNested<N> extends Nested<N>,PodSchedulingGateFluent<PodSpecFluent.SchedulingGatesNested<N>>{
    public N and();
    public N endSchedulingGate();
    
  }
  public interface SecurityContextNested<N> extends Nested<N>,PodSecurityContextFluent<PodSpecFluent.SecurityContextNested<N>>{
    public N and();
    public N endSecurityContext();
    
  }
  public interface TolerationsNested<N> extends Nested<N>,TolerationFluent<PodSpecFluent.TolerationsNested<N>>{
    public N and();
    public N endToleration();
    
  }
  public interface TopologySpreadConstraintsNested<N> extends Nested<N>,TopologySpreadConstraintFluent<PodSpecFluent.TopologySpreadConstraintsNested<N>>{
    public N and();
    public N endTopologySpreadConstraint();
    
  }
  public interface VolumesNested<N> extends Nested<N>,VolumeFluent<PodSpecFluent.VolumesNested<N>>{
    public N and();
    public N endVolume();
    
  }
  
}