package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProjectedVolumeSourceBuilder extends ProjectedVolumeSourceFluentImpl<ProjectedVolumeSourceBuilder> implements VisitableBuilder<ProjectedVolumeSource,ProjectedVolumeSourceBuilder>{
  public ProjectedVolumeSourceBuilder() {
    this(false);
  }
  public ProjectedVolumeSourceBuilder(Boolean validationEnabled) {
    this(new ProjectedVolumeSource(), validationEnabled);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProjectedVolumeSource(), validationEnabled);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSourceFluent<?> fluent,ProjectedVolumeSource instance) {
    this(fluent, instance, false);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSourceFluent<?> fluent,ProjectedVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDefaultMode(instance.getDefaultMode()); 
    fluent.withSources(instance.getSources()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSource instance) {
    this(instance,false);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withDefaultMode(instance.getDefaultMode()); 
    this.withSources(instance.getSources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ProjectedVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ProjectedVolumeSource build() {
    ProjectedVolumeSource buildable = new ProjectedVolumeSource(fluent.getDefaultMode(),fluent.getSources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}