package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ResourceQuotaSpecFluent<A extends ResourceQuotaSpecFluent<A>> extends Fluent<A>{
  public A addToHard(String key,Quantity value);
  public A addToHard(Map<String,Quantity> map);
  public A removeFromHard(String key);
  public A removeFromHard(Map<String,Quantity> map);
  public Map<String,Quantity> getHard();
  public <K,V>A withHard(Map<String,Quantity> hard);
  public Boolean hasHard();
  
  /**
   * This method has been deprecated, please use method buildScopeSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public ScopeSelector getScopeSelector();
  public ScopeSelector buildScopeSelector();
  public A withScopeSelector(ScopeSelector scopeSelector);
  public Boolean hasScopeSelector();
  public ResourceQuotaSpecFluent.ScopeSelectorNested<A> withNewScopeSelector();
  public ResourceQuotaSpecFluent.ScopeSelectorNested<A> withNewScopeSelectorLike(ScopeSelector item);
  public ResourceQuotaSpecFluent.ScopeSelectorNested<A> editScopeSelector();
  public ResourceQuotaSpecFluent.ScopeSelectorNested<A> editOrNewScopeSelector();
  public ResourceQuotaSpecFluent.ScopeSelectorNested<A> editOrNewScopeSelectorLike(ScopeSelector item);
  public A addToScopes(Integer index,String item);
  public A setToScopes(Integer index,String item);
  public A addToScopes(java.lang.String... items);
  public A addAllToScopes(Collection<String> items);
  public A removeFromScopes(java.lang.String... items);
  public A removeAllFromScopes(Collection<String> items);
  public List<String> getScopes();
  public String getScope(Integer index);
  public String getFirstScope();
  public String getLastScope();
  public String getMatchingScope(Predicate<String> predicate);
  public Boolean hasMatchingScope(Predicate<String> predicate);
  public A withScopes(List<String> scopes);
  public A withScopes(java.lang.String... scopes);
  public Boolean hasScopes();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ScopeSelectorNested<N> extends Nested<N>,ScopeSelectorFluent<ResourceQuotaSpecFluent.ScopeSelectorNested<N>>{
    public N and();
    public N endScopeSelector();
    
  }
  
}