package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VolumeProjectionFluentImpl<A extends VolumeProjectionFluent<A>> extends BaseFluent<A> implements VolumeProjectionFluent<A>{
  public VolumeProjectionFluentImpl() {
  }
  public VolumeProjectionFluentImpl(VolumeProjection instance) {
    this.withConfigMap(instance.getConfigMap()); 
    this.withDownwardAPI(instance.getDownwardAPI()); 
    this.withSecret(instance.getSecret()); 
    this.withServiceAccountToken(instance.getServiceAccountToken()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapProjectionBuilder configMap;
  private DownwardAPIProjectionBuilder downwardAPI;
  private SecretProjectionBuilder secret;
  private ServiceAccountTokenProjectionBuilder serviceAccountToken;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildConfigMap instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapProjection getConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public ConfigMapProjection buildConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public A withConfigMap(ConfigMapProjection configMap) {
    _visitables.get("configMap").remove(this.configMap);
    if (configMap!=null){ this.configMap= new ConfigMapProjectionBuilder(configMap); _visitables.get("configMap").add(this.configMap);} else { this.configMap = null; _visitables.get("configMap").remove(this.configMap); } return (A) this;
  }
  public Boolean hasConfigMap() {
    return this.configMap != null;
  }
  public VolumeProjectionFluent.ConfigMapNested<A> withNewConfigMap() {
    return new VolumeProjectionFluentImpl.ConfigMapNestedImpl();
  }
  public VolumeProjectionFluent.ConfigMapNested<A> withNewConfigMapLike(ConfigMapProjection item) {
    return new VolumeProjectionFluentImpl.ConfigMapNestedImpl(item);
  }
  public VolumeProjectionFluent.ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(getConfigMap());
  }
  public VolumeProjectionFluent.ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): new ConfigMapProjectionBuilder().build());
  }
  public VolumeProjectionFluent.ConfigMapNested<A> editOrNewConfigMapLike(ConfigMapProjection item) {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDownwardAPI instead.
   * @return The buildable object.
   */
  @Deprecated
  public DownwardAPIProjection getDownwardAPI() {
    return this.downwardAPI!=null ?this.downwardAPI.build():null;
  }
  public DownwardAPIProjection buildDownwardAPI() {
    return this.downwardAPI!=null ?this.downwardAPI.build():null;
  }
  public A withDownwardAPI(DownwardAPIProjection downwardAPI) {
    _visitables.get("downwardAPI").remove(this.downwardAPI);
    if (downwardAPI!=null){ this.downwardAPI= new DownwardAPIProjectionBuilder(downwardAPI); _visitables.get("downwardAPI").add(this.downwardAPI);} else { this.downwardAPI = null; _visitables.get("downwardAPI").remove(this.downwardAPI); } return (A) this;
  }
  public Boolean hasDownwardAPI() {
    return this.downwardAPI != null;
  }
  public VolumeProjectionFluent.DownwardAPINested<A> withNewDownwardAPI() {
    return new VolumeProjectionFluentImpl.DownwardAPINestedImpl();
  }
  public VolumeProjectionFluent.DownwardAPINested<A> withNewDownwardAPILike(DownwardAPIProjection item) {
    return new VolumeProjectionFluentImpl.DownwardAPINestedImpl(item);
  }
  public VolumeProjectionFluent.DownwardAPINested<A> editDownwardAPI() {
    return withNewDownwardAPILike(getDownwardAPI());
  }
  public VolumeProjectionFluent.DownwardAPINested<A> editOrNewDownwardAPI() {
    return withNewDownwardAPILike(getDownwardAPI() != null ? getDownwardAPI(): new DownwardAPIProjectionBuilder().build());
  }
  public VolumeProjectionFluent.DownwardAPINested<A> editOrNewDownwardAPILike(DownwardAPIProjection item) {
    return withNewDownwardAPILike(getDownwardAPI() != null ? getDownwardAPI(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSecret instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretProjection getSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public SecretProjection buildSecret() {
    return this.secret!=null ?this.secret.build():null;
  }
  public A withSecret(SecretProjection secret) {
    _visitables.get("secret").remove(this.secret);
    if (secret!=null){ this.secret= new SecretProjectionBuilder(secret); _visitables.get("secret").add(this.secret);} else { this.secret = null; _visitables.get("secret").remove(this.secret); } return (A) this;
  }
  public Boolean hasSecret() {
    return this.secret != null;
  }
  public VolumeProjectionFluent.SecretNested<A> withNewSecret() {
    return new VolumeProjectionFluentImpl.SecretNestedImpl();
  }
  public VolumeProjectionFluent.SecretNested<A> withNewSecretLike(SecretProjection item) {
    return new VolumeProjectionFluentImpl.SecretNestedImpl(item);
  }
  public VolumeProjectionFluent.SecretNested<A> editSecret() {
    return withNewSecretLike(getSecret());
  }
  public VolumeProjectionFluent.SecretNested<A> editOrNewSecret() {
    return withNewSecretLike(getSecret() != null ? getSecret(): new SecretProjectionBuilder().build());
  }
  public VolumeProjectionFluent.SecretNested<A> editOrNewSecretLike(SecretProjection item) {
    return withNewSecretLike(getSecret() != null ? getSecret(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildServiceAccountToken instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceAccountTokenProjection getServiceAccountToken() {
    return this.serviceAccountToken!=null ?this.serviceAccountToken.build():null;
  }
  public ServiceAccountTokenProjection buildServiceAccountToken() {
    return this.serviceAccountToken!=null ?this.serviceAccountToken.build():null;
  }
  public A withServiceAccountToken(ServiceAccountTokenProjection serviceAccountToken) {
    _visitables.get("serviceAccountToken").remove(this.serviceAccountToken);
    if (serviceAccountToken!=null){ this.serviceAccountToken= new ServiceAccountTokenProjectionBuilder(serviceAccountToken); _visitables.get("serviceAccountToken").add(this.serviceAccountToken);} else { this.serviceAccountToken = null; _visitables.get("serviceAccountToken").remove(this.serviceAccountToken); } return (A) this;
  }
  public Boolean hasServiceAccountToken() {
    return this.serviceAccountToken != null;
  }
  public A withNewServiceAccountToken(String audience,Long expirationSeconds,String path) {
    return (A)withServiceAccountToken(new ServiceAccountTokenProjection(audience, expirationSeconds, path));
  }
  public VolumeProjectionFluent.ServiceAccountTokenNested<A> withNewServiceAccountToken() {
    return new VolumeProjectionFluentImpl.ServiceAccountTokenNestedImpl();
  }
  public VolumeProjectionFluent.ServiceAccountTokenNested<A> withNewServiceAccountTokenLike(ServiceAccountTokenProjection item) {
    return new VolumeProjectionFluentImpl.ServiceAccountTokenNestedImpl(item);
  }
  public VolumeProjectionFluent.ServiceAccountTokenNested<A> editServiceAccountToken() {
    return withNewServiceAccountTokenLike(getServiceAccountToken());
  }
  public VolumeProjectionFluent.ServiceAccountTokenNested<A> editOrNewServiceAccountToken() {
    return withNewServiceAccountTokenLike(getServiceAccountToken() != null ? getServiceAccountToken(): new ServiceAccountTokenProjectionBuilder().build());
  }
  public VolumeProjectionFluent.ServiceAccountTokenNested<A> editOrNewServiceAccountTokenLike(ServiceAccountTokenProjection item) {
    return withNewServiceAccountTokenLike(getServiceAccountToken() != null ? getServiceAccountToken(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VolumeProjectionFluentImpl that = (VolumeProjectionFluentImpl) o;
    if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
    if (downwardAPI != null ? !downwardAPI.equals(that.downwardAPI) :that.downwardAPI != null) return false;
    if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
    if (serviceAccountToken != null ? !serviceAccountToken.equals(that.serviceAccountToken) :that.serviceAccountToken != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMap,  downwardAPI,  secret,  serviceAccountToken,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (downwardAPI != null) { sb.append("downwardAPI:"); sb.append(downwardAPI + ","); }
    if (secret != null) { sb.append("secret:"); sb.append(secret + ","); }
    if (serviceAccountToken != null) { sb.append("serviceAccountToken:"); sb.append(serviceAccountToken + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConfigMapNestedImpl<N> extends ConfigMapProjectionFluentImpl<VolumeProjectionFluent.ConfigMapNested<N>> implements VolumeProjectionFluent.ConfigMapNested<N>,Nested<N>{
    ConfigMapNestedImpl(ConfigMapProjection item) {
      this.builder = new ConfigMapProjectionBuilder(this, item);
    }
    ConfigMapNestedImpl() {
      this.builder = new ConfigMapProjectionBuilder(this);
    }
    ConfigMapProjectionBuilder builder;
    public N and() {
      return (N) VolumeProjectionFluentImpl.this.withConfigMap(builder.build());
    }
    public N endConfigMap() {
      return and();
    }
    
  }
  class DownwardAPINestedImpl<N> extends DownwardAPIProjectionFluentImpl<VolumeProjectionFluent.DownwardAPINested<N>> implements VolumeProjectionFluent.DownwardAPINested<N>,Nested<N>{
    DownwardAPINestedImpl(DownwardAPIProjection item) {
      this.builder = new DownwardAPIProjectionBuilder(this, item);
    }
    DownwardAPINestedImpl() {
      this.builder = new DownwardAPIProjectionBuilder(this);
    }
    DownwardAPIProjectionBuilder builder;
    public N and() {
      return (N) VolumeProjectionFluentImpl.this.withDownwardAPI(builder.build());
    }
    public N endDownwardAPI() {
      return and();
    }
    
  }
  class SecretNestedImpl<N> extends SecretProjectionFluentImpl<VolumeProjectionFluent.SecretNested<N>> implements VolumeProjectionFluent.SecretNested<N>,Nested<N>{
    SecretNestedImpl(SecretProjection item) {
      this.builder = new SecretProjectionBuilder(this, item);
    }
    SecretNestedImpl() {
      this.builder = new SecretProjectionBuilder(this);
    }
    SecretProjectionBuilder builder;
    public N and() {
      return (N) VolumeProjectionFluentImpl.this.withSecret(builder.build());
    }
    public N endSecret() {
      return and();
    }
    
  }
  class ServiceAccountTokenNestedImpl<N> extends ServiceAccountTokenProjectionFluentImpl<VolumeProjectionFluent.ServiceAccountTokenNested<N>> implements VolumeProjectionFluent.ServiceAccountTokenNested<N>,Nested<N>{
    ServiceAccountTokenNestedImpl(ServiceAccountTokenProjection item) {
      this.builder = new ServiceAccountTokenProjectionBuilder(this, item);
    }
    ServiceAccountTokenNestedImpl() {
      this.builder = new ServiceAccountTokenProjectionBuilder(this);
    }
    ServiceAccountTokenProjectionBuilder builder;
    public N and() {
      return (N) VolumeProjectionFluentImpl.this.withServiceAccountToken(builder.build());
    }
    public N endServiceAccountToken() {
      return and();
    }
    
  }
  
}