package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
public interface KubernetesListFluent<A extends KubernetesListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(VisitableBuilder<? extends HasMetadata,?> builder);
  public A addToItems(Integer index,VisitableBuilder<? extends HasMetadata,?> builder);
  public A addToItems(Integer index,HasMetadata item);
  public A setToItems(Integer index,HasMetadata item);
  public A addToItems(io.fabric8.kubernetes.api.model.HasMetadata... items);
  public A addAllToItems(Collection<HasMetadata> items);
  public A removeFromItems(VisitableBuilder<? extends HasMetadata,?> builder);
  public A removeFromItems(io.fabric8.kubernetes.api.model.HasMetadata... items);
  public A removeAllFromItems(Collection<HasMetadata> items);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HasMetadata> getItems();
  public List<HasMetadata> buildItems();
  public HasMetadata buildItem(Integer index);
  public HasMetadata buildFirstItem();
  public HasMetadata buildLastItem();
  public HasMetadata buildMatchingItem(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public Boolean hasMatchingItem(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public A withItems(List<HasMetadata> items);
  public A withItems(io.fabric8.kubernetes.api.model.HasMetadata... items);
  public Boolean hasItems();
  public A addToLimitRangeItems(Integer index,LimitRange item);
  public A setToLimitRangeItems(Integer index,LimitRange item);
  public A addToLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items);
  public A addAllToLimitRangeItems(Collection<LimitRange> items);
  public A removeFromLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items);
  public A removeAllFromLimitRangeItems(Collection<LimitRange> items);
  public A removeMatchingFromLimitRangeItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.LimitRangeItemsNested<A> setNewLimitRangeItemLike(Integer index,LimitRange item);
  public KubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem();
  public KubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(LimitRange item);
  public A addToAPIServiceItems(Integer index,APIService item);
  public A setToAPIServiceItems(Integer index,APIService item);
  public A addToAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items);
  public A addAllToAPIServiceItems(Collection<APIService> items);
  public A removeFromAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items);
  public A removeAllFromAPIServiceItems(Collection<APIService> items);
  public A removeMatchingFromAPIServiceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.APIServiceItemsNested<A> setNewAPIServiceItemLike(Integer index,APIService item);
  public KubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItem();
  public KubernetesListFluent.APIServiceItemsNested<A> addNewAPIServiceItemLike(APIService item);
  public A addToNamespaceItems(Integer index,Namespace item);
  public A setToNamespaceItems(Integer index,Namespace item);
  public A addToNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items);
  public A addAllToNamespaceItems(Collection<Namespace> items);
  public A removeFromNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items);
  public A removeAllFromNamespaceItems(Collection<Namespace> items);
  public A removeMatchingFromNamespaceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.NamespaceItemsNested<A> setNewNamespaceItemLike(Integer index,Namespace item);
  public KubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem();
  public KubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(Namespace item);
  public A addToServiceItems(Integer index,Service item);
  public A setToServiceItems(Integer index,Service item);
  public A addToServiceItems(io.fabric8.kubernetes.api.model.Service... items);
  public A addAllToServiceItems(Collection<Service> items);
  public A removeFromServiceItems(io.fabric8.kubernetes.api.model.Service... items);
  public A removeAllFromServiceItems(Collection<Service> items);
  public A removeMatchingFromServiceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.ServiceItemsNested<A> setNewServiceItemLike(Integer index,Service item);
  public KubernetesListFluent.ServiceItemsNested<A> addNewServiceItem();
  public KubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(Service item);
  public A addToReplicationControllerItems(Integer index,ReplicationController item);
  public A setToReplicationControllerItems(Integer index,ReplicationController item);
  public A addToReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items);
  public A addAllToReplicationControllerItems(Collection<ReplicationController> items);
  public A removeFromReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items);
  public A removeAllFromReplicationControllerItems(Collection<ReplicationController> items);
  public A removeMatchingFromReplicationControllerItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.ReplicationControllerItemsNested<A> setNewReplicationControllerItemLike(Integer index,ReplicationController item);
  public KubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem();
  public KubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(ReplicationController item);
  public A addToPodTemplateItems(Integer index,PodTemplate item);
  public A setToPodTemplateItems(Integer index,PodTemplate item);
  public A addToPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items);
  public A addAllToPodTemplateItems(Collection<PodTemplate> items);
  public A removeFromPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items);
  public A removeAllFromPodTemplateItems(Collection<PodTemplate> items);
  public A removeMatchingFromPodTemplateItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.PodTemplateItemsNested<A> setNewPodTemplateItemLike(Integer index,PodTemplate item);
  public KubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem();
  public KubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(PodTemplate item);
  public A addToEventItems(Integer index,Event item);
  public A setToEventItems(Integer index,Event item);
  public A addToEventItems(io.fabric8.kubernetes.api.model.Event... items);
  public A addAllToEventItems(Collection<Event> items);
  public A removeFromEventItems(io.fabric8.kubernetes.api.model.Event... items);
  public A removeAllFromEventItems(Collection<Event> items);
  public A removeMatchingFromEventItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.EventItemsNested<A> setNewEventItemLike(Integer index,Event item);
  public KubernetesListFluent.EventItemsNested<A> addNewEventItem();
  public KubernetesListFluent.EventItemsNested<A> addNewEventItemLike(Event item);
  public A addToPersistentVolumeItems(Integer index,PersistentVolume item);
  public A setToPersistentVolumeItems(Integer index,PersistentVolume item);
  public A addToPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items);
  public A addAllToPersistentVolumeItems(Collection<PersistentVolume> items);
  public A removeFromPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items);
  public A removeAllFromPersistentVolumeItems(Collection<PersistentVolume> items);
  public A removeMatchingFromPersistentVolumeItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.PersistentVolumeItemsNested<A> setNewPersistentVolumeItemLike(Integer index,PersistentVolume item);
  public KubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem();
  public KubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(PersistentVolume item);
  public A addToPersistentVolumeClaimItems(Integer index,PersistentVolumeClaim item);
  public A setToPersistentVolumeClaimItems(Integer index,PersistentVolumeClaim item);
  public A addToPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
  public A addAllToPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items);
  public A removeFromPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items);
  public A removeAllFromPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items);
  public A removeMatchingFromPersistentVolumeClaimItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.PersistentVolumeClaimItemsNested<A> setNewPersistentVolumeClaimItemLike(Integer index,PersistentVolumeClaim item);
  public KubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem();
  public KubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(PersistentVolumeClaim item);
  public A addToGenericKubernetesResourceItems(Integer index,GenericKubernetesResource item);
  public A setToGenericKubernetesResourceItems(Integer index,GenericKubernetesResource item);
  public A addToGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items);
  public A addAllToGenericKubernetesResourceItems(Collection<GenericKubernetesResource> items);
  public A removeFromGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items);
  public A removeAllFromGenericKubernetesResourceItems(Collection<GenericKubernetesResource> items);
  public A removeMatchingFromGenericKubernetesResourceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.GenericKubernetesResourceItemsNested<A> setNewGenericKubernetesResourceItemLike(Integer index,GenericKubernetesResource item);
  public KubernetesListFluent.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItem();
  public KubernetesListFluent.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItemLike(GenericKubernetesResource item);
  public A addToEndpointsItems(Integer index,Endpoints item);
  public A setToEndpointsItems(Integer index,Endpoints item);
  public A addToEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items);
  public A addAllToEndpointsItems(Collection<Endpoints> items);
  public A removeFromEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items);
  public A removeAllFromEndpointsItems(Collection<Endpoints> items);
  public A removeMatchingFromEndpointsItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.EndpointsItemsNested<A> setNewEndpointsItemLike(Integer index,Endpoints item);
  public KubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem();
  public KubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(Endpoints item);
  public A addToPodItems(Integer index,Pod item);
  public A setToPodItems(Integer index,Pod item);
  public A addToPodItems(io.fabric8.kubernetes.api.model.Pod... items);
  public A addAllToPodItems(Collection<Pod> items);
  public A removeFromPodItems(io.fabric8.kubernetes.api.model.Pod... items);
  public A removeAllFromPodItems(Collection<Pod> items);
  public A removeMatchingFromPodItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.PodItemsNested<A> setNewPodItemLike(Integer index,Pod item);
  public KubernetesListFluent.PodItemsNested<A> addNewPodItem();
  public KubernetesListFluent.PodItemsNested<A> addNewPodItemLike(Pod item);
  public A addToConfigMapItems(Integer index,ConfigMap item);
  public A setToConfigMapItems(Integer index,ConfigMap item);
  public A addToConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items);
  public A addAllToConfigMapItems(Collection<ConfigMap> items);
  public A removeFromConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items);
  public A removeAllFromConfigMapItems(Collection<ConfigMap> items);
  public A removeMatchingFromConfigMapItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.ConfigMapItemsNested<A> setNewConfigMapItemLike(Integer index,ConfigMap item);
  public KubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItem();
  public KubernetesListFluent.ConfigMapItemsNested<A> addNewConfigMapItemLike(ConfigMap item);
  public A addToComponentStatusItems(Integer index,ComponentStatus item);
  public A setToComponentStatusItems(Integer index,ComponentStatus item);
  public A addToComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items);
  public A addAllToComponentStatusItems(Collection<ComponentStatus> items);
  public A removeFromComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items);
  public A removeAllFromComponentStatusItems(Collection<ComponentStatus> items);
  public A removeMatchingFromComponentStatusItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.ComponentStatusItemsNested<A> setNewComponentStatusItemLike(Integer index,ComponentStatus item);
  public KubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem();
  public KubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(ComponentStatus item);
  public A addToBindingItems(Integer index,Binding item);
  public A setToBindingItems(Integer index,Binding item);
  public A addToBindingItems(io.fabric8.kubernetes.api.model.Binding... items);
  public A addAllToBindingItems(Collection<Binding> items);
  public A removeFromBindingItems(io.fabric8.kubernetes.api.model.Binding... items);
  public A removeAllFromBindingItems(Collection<Binding> items);
  public A removeMatchingFromBindingItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.BindingItemsNested<A> setNewBindingItemLike(Integer index,Binding item);
  public KubernetesListFluent.BindingItemsNested<A> addNewBindingItem();
  public KubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(Binding item);
  public A addToResourceQuotaItems(Integer index,ResourceQuota item);
  public A setToResourceQuotaItems(Integer index,ResourceQuota item);
  public A addToResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items);
  public A addAllToResourceQuotaItems(Collection<ResourceQuota> items);
  public A removeFromResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items);
  public A removeAllFromResourceQuotaItems(Collection<ResourceQuota> items);
  public A removeMatchingFromResourceQuotaItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.ResourceQuotaItemsNested<A> setNewResourceQuotaItemLike(Integer index,ResourceQuota item);
  public KubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem();
  public KubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(ResourceQuota item);
  public A addToSecretItems(Integer index,Secret item);
  public A setToSecretItems(Integer index,Secret item);
  public A addToSecretItems(io.fabric8.kubernetes.api.model.Secret... items);
  public A addAllToSecretItems(Collection<Secret> items);
  public A removeFromSecretItems(io.fabric8.kubernetes.api.model.Secret... items);
  public A removeAllFromSecretItems(Collection<Secret> items);
  public A removeMatchingFromSecretItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.SecretItemsNested<A> setNewSecretItemLike(Integer index,Secret item);
  public KubernetesListFluent.SecretItemsNested<A> addNewSecretItem();
  public KubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(Secret item);
  public A addToNodeItems(Integer index,Node item);
  public A setToNodeItems(Integer index,Node item);
  public A addToNodeItems(io.fabric8.kubernetes.api.model.Node... items);
  public A addAllToNodeItems(Collection<Node> items);
  public A removeFromNodeItems(io.fabric8.kubernetes.api.model.Node... items);
  public A removeAllFromNodeItems(Collection<Node> items);
  public A removeMatchingFromNodeItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.NodeItemsNested<A> setNewNodeItemLike(Integer index,Node item);
  public KubernetesListFluent.NodeItemsNested<A> addNewNodeItem();
  public KubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(Node item);
  public A addToServiceAccountItems(Integer index,ServiceAccount item);
  public A setToServiceAccountItems(Integer index,ServiceAccount item);
  public A addToServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items);
  public A addAllToServiceAccountItems(Collection<ServiceAccount> items);
  public A removeFromServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items);
  public A removeAllFromServiceAccountItems(Collection<ServiceAccount> items);
  public A removeMatchingFromServiceAccountItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate);
  public KubernetesListFluent.ServiceAccountItemsNested<A> setNewServiceAccountItemLike(Integer index,ServiceAccount item);
  public KubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem();
  public KubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(ServiceAccount item);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public KubernetesListFluent.MetadataNested<A> withNewMetadata();
  public KubernetesListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public KubernetesListFluent.MetadataNested<A> editMetadata();
  public KubernetesListFluent.MetadataNested<A> editOrNewMetadata();
  public KubernetesListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public interface LimitRangeItemsNested<N> extends Nested<N>,LimitRangeFluent<KubernetesListFluent.LimitRangeItemsNested<N>>{
    public N and();
    public N endLimitRangeItem();
    
  }
  public interface APIServiceItemsNested<N> extends Nested<N>,APIServiceFluent<KubernetesListFluent.APIServiceItemsNested<N>>{
    public N and();
    public N endAPIServiceItem();
    
  }
  public interface NamespaceItemsNested<N> extends Nested<N>,NamespaceFluent<KubernetesListFluent.NamespaceItemsNested<N>>{
    public N and();
    public N endNamespaceItem();
    
  }
  public interface ServiceItemsNested<N> extends Nested<N>,ServiceFluent<KubernetesListFluent.ServiceItemsNested<N>>{
    public N and();
    public N endServiceItem();
    
  }
  public interface ReplicationControllerItemsNested<N> extends Nested<N>,ReplicationControllerFluent<KubernetesListFluent.ReplicationControllerItemsNested<N>>{
    public N and();
    public N endReplicationControllerItem();
    
  }
  public interface PodTemplateItemsNested<N> extends Nested<N>,PodTemplateFluent<KubernetesListFluent.PodTemplateItemsNested<N>>{
    public N and();
    public N endPodTemplateItem();
    
  }
  public interface EventItemsNested<N> extends Nested<N>,EventFluent<KubernetesListFluent.EventItemsNested<N>>{
    public N and();
    public N endEventItem();
    
  }
  public interface PersistentVolumeItemsNested<N> extends Nested<N>,PersistentVolumeFluent<KubernetesListFluent.PersistentVolumeItemsNested<N>>{
    public N and();
    public N endPersistentVolumeItem();
    
  }
  public interface PersistentVolumeClaimItemsNested<N> extends Nested<N>,PersistentVolumeClaimFluent<KubernetesListFluent.PersistentVolumeClaimItemsNested<N>>{
    public N and();
    public N endPersistentVolumeClaimItem();
    
  }
  public interface GenericKubernetesResourceItemsNested<N> extends Nested<N>,GenericKubernetesResourceFluent<KubernetesListFluent.GenericKubernetesResourceItemsNested<N>>{
    public N and();
    public N endGenericKubernetesResourceItem();
    
  }
  public interface EndpointsItemsNested<N> extends Nested<N>,EndpointsFluent<KubernetesListFluent.EndpointsItemsNested<N>>{
    public N and();
    public N endEndpointsItem();
    
  }
  public interface PodItemsNested<N> extends Nested<N>,PodFluent<KubernetesListFluent.PodItemsNested<N>>{
    public N and();
    public N endPodItem();
    
  }
  public interface ConfigMapItemsNested<N> extends Nested<N>,ConfigMapFluent<KubernetesListFluent.ConfigMapItemsNested<N>>{
    public N and();
    public N endConfigMapItem();
    
  }
  public interface ComponentStatusItemsNested<N> extends Nested<N>,ComponentStatusFluent<KubernetesListFluent.ComponentStatusItemsNested<N>>{
    public N and();
    public N endComponentStatusItem();
    
  }
  public interface BindingItemsNested<N> extends Nested<N>,BindingFluent<KubernetesListFluent.BindingItemsNested<N>>{
    public N and();
    public N endBindingItem();
    
  }
  public interface ResourceQuotaItemsNested<N> extends Nested<N>,ResourceQuotaFluent<KubernetesListFluent.ResourceQuotaItemsNested<N>>{
    public N and();
    public N endResourceQuotaItem();
    
  }
  public interface SecretItemsNested<N> extends Nested<N>,SecretFluent<KubernetesListFluent.SecretItemsNested<N>>{
    public N and();
    public N endSecretItem();
    
  }
  public interface NodeItemsNested<N> extends Nested<N>,NodeFluent<KubernetesListFluent.NodeItemsNested<N>>{
    public N and();
    public N endNodeItem();
    
  }
  public interface ServiceAccountItemsNested<N> extends Nested<N>,ServiceAccountFluent<KubernetesListFluent.ServiceAccountItemsNested<N>>{
    public N and();
    public N endServiceAccountItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<KubernetesListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}