package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeConfigStatusBuilder extends NodeConfigStatusFluentImpl<NodeConfigStatusBuilder> implements VisitableBuilder<NodeConfigStatus,NodeConfigStatusBuilder>{
  public NodeConfigStatusBuilder() {
    this(false);
  }
  public NodeConfigStatusBuilder(Boolean validationEnabled) {
    this(new NodeConfigStatus(), validationEnabled);
  }
  public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeConfigStatus(), validationEnabled);
  }
  public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent,NodeConfigStatus instance) {
    this(fluent, instance, false);
  }
  public NodeConfigStatusBuilder(NodeConfigStatusFluent<?> fluent,NodeConfigStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withActive(instance.getActive()); 
    fluent.withAssigned(instance.getAssigned()); 
    fluent.withError(instance.getError()); 
    fluent.withLastKnownGood(instance.getLastKnownGood()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NodeConfigStatusBuilder(NodeConfigStatus instance) {
    this(instance,false);
  }
  public NodeConfigStatusBuilder(NodeConfigStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withActive(instance.getActive()); 
    this.withAssigned(instance.getAssigned()); 
    this.withError(instance.getError()); 
    this.withLastKnownGood(instance.getLastKnownGood()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NodeConfigStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NodeConfigStatus build() {
    NodeConfigStatus buildable = new NodeConfigStatus(fluent.getActive(),fluent.getAssigned(),fluent.getError(),fluent.getLastKnownGood());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}