package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PersistentVolumeClaimSpecFluentImpl<A extends PersistentVolumeClaimSpecFluent<A>> extends BaseFluent<A> implements PersistentVolumeClaimSpecFluent<A>{
  public PersistentVolumeClaimSpecFluentImpl() {
  }
  public PersistentVolumeClaimSpecFluentImpl(PersistentVolumeClaimSpec instance) {
    this.withAccessModes(instance.getAccessModes()); 
    this.withDataSource(instance.getDataSource()); 
    this.withDataSourceRef(instance.getDataSourceRef()); 
    this.withResources(instance.getResources()); 
    this.withSelector(instance.getSelector()); 
    this.withStorageClassName(instance.getStorageClassName()); 
    this.withVolumeMode(instance.getVolumeMode()); 
    this.withVolumeName(instance.getVolumeName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> accessModes = new ArrayList<String>();
  private TypedLocalObjectReferenceBuilder dataSource;
  private TypedObjectReferenceBuilder dataSourceRef;
  private ResourceRequirementsBuilder resources;
  private LabelSelectorBuilder selector;
  private String storageClassName;
  private String volumeMode;
  private String volumeName;
  private Map<String,Object> additionalProperties;
  public A addToAccessModes(Integer index,String item) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    this.accessModes.add(index, item);
    return (A)this;
  }
  public A setToAccessModes(Integer index,String item) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    this.accessModes.set(index, item); return (A)this;
  }
  public A addToAccessModes(java.lang.String... items) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    for (String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A addAllToAccessModes(Collection<String> items) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    for (String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A removeFromAccessModes(java.lang.String... items) {
    for (String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public A removeAllFromAccessModes(Collection<String> items) {
    for (String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public List<String> getAccessModes() {
    return this.accessModes;
  }
  public String getAccessMode(Integer index) {
    return this.accessModes.get(index);
  }
  public String getFirstAccessMode() {
    return this.accessModes.get(0);
  }
  public String getLastAccessMode() {
    return this.accessModes.get(accessModes.size() - 1);
  }
  public String getMatchingAccessMode(Predicate<String> predicate) {
    for (String item: accessModes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAccessMode(Predicate<String> predicate) {
    for (String item: accessModes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAccessModes(List<String> accessModes) {
    if (accessModes != null) {this.accessModes = new ArrayList(); for (String item : accessModes){this.addToAccessModes(item);}} else { this.accessModes = null;} return (A) this;
  }
  public A withAccessModes(java.lang.String... accessModes) {
    if (this.accessModes != null) {this.accessModes.clear();}
    if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
  }
  public Boolean hasAccessModes() {
    return accessModes != null && !accessModes.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildDataSource instead.
   * @return The buildable object.
   */
  @Deprecated
  public TypedLocalObjectReference getDataSource() {
    return this.dataSource!=null ?this.dataSource.build():null;
  }
  public TypedLocalObjectReference buildDataSource() {
    return this.dataSource!=null ?this.dataSource.build():null;
  }
  public A withDataSource(TypedLocalObjectReference dataSource) {
    _visitables.get("dataSource").remove(this.dataSource);
    if (dataSource!=null){ this.dataSource= new TypedLocalObjectReferenceBuilder(dataSource); _visitables.get("dataSource").add(this.dataSource);} else { this.dataSource = null; _visitables.get("dataSource").remove(this.dataSource); } return (A) this;
  }
  public Boolean hasDataSource() {
    return this.dataSource != null;
  }
  public A withNewDataSource(String apiGroup,String kind,String name) {
    return (A)withDataSource(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSource() {
    return new PersistentVolumeClaimSpecFluentImpl.DataSourceNestedImpl();
  }
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSourceLike(TypedLocalObjectReference item) {
    return new PersistentVolumeClaimSpecFluentImpl.DataSourceNestedImpl(item);
  }
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editDataSource() {
    return withNewDataSourceLike(getDataSource());
  }
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSource() {
    return withNewDataSourceLike(getDataSource() != null ? getDataSource(): new TypedLocalObjectReferenceBuilder().build());
  }
  public PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSourceLike(TypedLocalObjectReference item) {
    return withNewDataSourceLike(getDataSource() != null ? getDataSource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildDataSourceRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public TypedObjectReference getDataSourceRef() {
    return this.dataSourceRef!=null ?this.dataSourceRef.build():null;
  }
  public TypedObjectReference buildDataSourceRef() {
    return this.dataSourceRef!=null ?this.dataSourceRef.build():null;
  }
  public A withDataSourceRef(TypedObjectReference dataSourceRef) {
    _visitables.get("dataSourceRef").remove(this.dataSourceRef);
    if (dataSourceRef!=null){ this.dataSourceRef= new TypedObjectReferenceBuilder(dataSourceRef); _visitables.get("dataSourceRef").add(this.dataSourceRef);} else { this.dataSourceRef = null; _visitables.get("dataSourceRef").remove(this.dataSourceRef); } return (A) this;
  }
  public Boolean hasDataSourceRef() {
    return this.dataSourceRef != null;
  }
  public A withNewDataSourceRef(String apiGroup,String kind,String name,String namespace) {
    return (A)withDataSourceRef(new TypedObjectReference(apiGroup, kind, name, namespace));
  }
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> withNewDataSourceRef() {
    return new PersistentVolumeClaimSpecFluentImpl.DataSourceRefNestedImpl();
  }
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> withNewDataSourceRefLike(TypedObjectReference item) {
    return new PersistentVolumeClaimSpecFluentImpl.DataSourceRefNestedImpl(item);
  }
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editDataSourceRef() {
    return withNewDataSourceRefLike(getDataSourceRef());
  }
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editOrNewDataSourceRef() {
    return withNewDataSourceRefLike(getDataSourceRef() != null ? getDataSourceRef(): new TypedObjectReferenceBuilder().build());
  }
  public PersistentVolumeClaimSpecFluent.DataSourceRefNested<A> editOrNewDataSourceRefLike(TypedObjectReference item) {
    return withNewDataSourceRefLike(getDataSourceRef() != null ? getDataSourceRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResources instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceRequirements getResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public ResourceRequirements buildResources() {
    return this.resources!=null ?this.resources.build():null;
  }
  public A withResources(ResourceRequirements resources) {
    _visitables.get("resources").remove(this.resources);
    if (resources!=null){ this.resources= new ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} else { this.resources = null; _visitables.get("resources").remove(this.resources); } return (A) this;
  }
  public Boolean hasResources() {
    return this.resources != null;
  }
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources() {
    return new PersistentVolumeClaimSpecFluentImpl.ResourcesNestedImpl();
  }
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new PersistentVolumeClaimSpecFluentImpl.ResourcesNestedImpl(item);
  }
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources() {
    return withNewResourcesLike(getResources());
  }
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(getResources() != null ? getResources(): new ResourceRequirementsBuilder().build());
  }
  public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(getResources() != null ? getResources(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelector() {
    return new PersistentVolumeClaimSpecFluentImpl.SelectorNestedImpl();
  }
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new PersistentVolumeClaimSpecFluentImpl.SelectorNestedImpl(item);
  }
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getStorageClassName() {
    return this.storageClassName;
  }
  public A withStorageClassName(String storageClassName) {
    this.storageClassName=storageClassName; return (A) this;
  }
  public Boolean hasStorageClassName() {
    return this.storageClassName != null;
  }
  public String getVolumeMode() {
    return this.volumeMode;
  }
  public A withVolumeMode(String volumeMode) {
    this.volumeMode=volumeMode; return (A) this;
  }
  public Boolean hasVolumeMode() {
    return this.volumeMode != null;
  }
  public String getVolumeName() {
    return this.volumeName;
  }
  public A withVolumeName(String volumeName) {
    this.volumeName=volumeName; return (A) this;
  }
  public Boolean hasVolumeName() {
    return this.volumeName != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PersistentVolumeClaimSpecFluentImpl that = (PersistentVolumeClaimSpecFluentImpl) o;
    if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
    if (dataSource != null ? !dataSource.equals(that.dataSource) :that.dataSource != null) return false;
    if (dataSourceRef != null ? !dataSourceRef.equals(that.dataSourceRef) :that.dataSourceRef != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (storageClassName != null ? !storageClassName.equals(that.storageClassName) :that.storageClassName != null) return false;
    if (volumeMode != null ? !volumeMode.equals(that.volumeMode) :that.volumeMode != null) return false;
    if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessModes,  dataSource,  dataSourceRef,  resources,  selector,  storageClassName,  volumeMode,  volumeName,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessModes != null && !accessModes.isEmpty()) { sb.append("accessModes:"); sb.append(accessModes + ","); }
    if (dataSource != null) { sb.append("dataSource:"); sb.append(dataSource + ","); }
    if (dataSourceRef != null) { sb.append("dataSourceRef:"); sb.append(dataSourceRef + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (storageClassName != null) { sb.append("storageClassName:"); sb.append(storageClassName + ","); }
    if (volumeMode != null) { sb.append("volumeMode:"); sb.append(volumeMode + ","); }
    if (volumeName != null) { sb.append("volumeName:"); sb.append(volumeName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class DataSourceNestedImpl<N> extends TypedLocalObjectReferenceFluentImpl<PersistentVolumeClaimSpecFluent.DataSourceNested<N>> implements PersistentVolumeClaimSpecFluent.DataSourceNested<N>,Nested<N>{
    DataSourceNestedImpl(TypedLocalObjectReference item) {
      this.builder = new TypedLocalObjectReferenceBuilder(this, item);
    }
    DataSourceNestedImpl() {
      this.builder = new TypedLocalObjectReferenceBuilder(this);
    }
    TypedLocalObjectReferenceBuilder builder;
    public N and() {
      return (N) PersistentVolumeClaimSpecFluentImpl.this.withDataSource(builder.build());
    }
    public N endDataSource() {
      return and();
    }
    
  }
  class DataSourceRefNestedImpl<N> extends TypedObjectReferenceFluentImpl<PersistentVolumeClaimSpecFluent.DataSourceRefNested<N>> implements PersistentVolumeClaimSpecFluent.DataSourceRefNested<N>,Nested<N>{
    DataSourceRefNestedImpl(TypedObjectReference item) {
      this.builder = new TypedObjectReferenceBuilder(this, item);
    }
    DataSourceRefNestedImpl() {
      this.builder = new TypedObjectReferenceBuilder(this);
    }
    TypedObjectReferenceBuilder builder;
    public N and() {
      return (N) PersistentVolumeClaimSpecFluentImpl.this.withDataSourceRef(builder.build());
    }
    public N endDataSourceRef() {
      return and();
    }
    
  }
  class ResourcesNestedImpl<N> extends ResourceRequirementsFluentImpl<PersistentVolumeClaimSpecFluent.ResourcesNested<N>> implements PersistentVolumeClaimSpecFluent.ResourcesNested<N>,Nested<N>{
    ResourcesNestedImpl(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourcesNestedImpl() {
      this.builder = new ResourceRequirementsBuilder(this);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) PersistentVolumeClaimSpecFluentImpl.this.withResources(builder.build());
    }
    public N endResources() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<PersistentVolumeClaimSpecFluent.SelectorNested<N>> implements PersistentVolumeClaimSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) PersistentVolumeClaimSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  
}