package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSchedulingGateBuilder extends PodSchedulingGateFluentImpl<PodSchedulingGateBuilder> implements VisitableBuilder<PodSchedulingGate,PodSchedulingGateBuilder>{
  public PodSchedulingGateBuilder() {
    this(false);
  }
  public PodSchedulingGateBuilder(Boolean validationEnabled) {
    this(new PodSchedulingGate(), validationEnabled);
  }
  public PodSchedulingGateBuilder(PodSchedulingGateFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSchedulingGateBuilder(PodSchedulingGateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSchedulingGate(), validationEnabled);
  }
  public PodSchedulingGateBuilder(PodSchedulingGateFluent<?> fluent,PodSchedulingGate instance) {
    this(fluent, instance, false);
  }
  public PodSchedulingGateBuilder(PodSchedulingGateFluent<?> fluent,PodSchedulingGate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodSchedulingGateBuilder(PodSchedulingGate instance) {
    this(instance,false);
  }
  public PodSchedulingGateBuilder(PodSchedulingGate instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodSchedulingGateFluent<?> fluent;
  Boolean validationEnabled;
  public PodSchedulingGate build() {
    PodSchedulingGate buildable = new PodSchedulingGate(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}