package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodSpecFluentImpl<A extends PodSpecFluent<A>> extends BaseFluent<A> implements PodSpecFluent<A>{
  public PodSpecFluentImpl() {
  }
  public PodSpecFluentImpl(PodSpec instance) {
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    this.withAffinity(instance.getAffinity()); 
    this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken()); 
    this.withContainers(instance.getContainers()); 
    this.withDnsConfig(instance.getDnsConfig()); 
    this.withDnsPolicy(instance.getDnsPolicy()); 
    this.withEnableServiceLinks(instance.getEnableServiceLinks()); 
    this.withEphemeralContainers(instance.getEphemeralContainers()); 
    this.withHostAliases(instance.getHostAliases()); 
    this.withHostIPC(instance.getHostIPC()); 
    this.withHostNetwork(instance.getHostNetwork()); 
    this.withHostPID(instance.getHostPID()); 
    this.withHostUsers(instance.getHostUsers()); 
    this.withHostname(instance.getHostname()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withNodeName(instance.getNodeName()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withOs(instance.getOs()); 
    this.withOverhead(instance.getOverhead()); 
    this.withPreemptionPolicy(instance.getPreemptionPolicy()); 
    this.withPriority(instance.getPriority()); 
    this.withPriorityClassName(instance.getPriorityClassName()); 
    this.withReadinessGates(instance.getReadinessGates()); 
    this.withResourceClaims(instance.getResourceClaims()); 
    this.withRestartPolicy(instance.getRestartPolicy()); 
    this.withRuntimeClassName(instance.getRuntimeClassName()); 
    this.withSchedulerName(instance.getSchedulerName()); 
    this.withSchedulingGates(instance.getSchedulingGates()); 
    this.withSecurityContext(instance.getSecurityContext()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withServiceAccountName(instance.getServiceAccountName()); 
    this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN()); 
    this.withShareProcessNamespace(instance.getShareProcessNamespace()); 
    this.withSubdomain(instance.getSubdomain()); 
    this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
    this.withTolerations(instance.getTolerations()); 
    this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Long activeDeadlineSeconds;
  private AffinityBuilder affinity;
  private Boolean automountServiceAccountToken;
  private ArrayList<ContainerBuilder> containers = new ArrayList<ContainerBuilder>();
  private PodDNSConfigBuilder dnsConfig;
  private String dnsPolicy;
  private Boolean enableServiceLinks;
  private ArrayList<EphemeralContainerBuilder> ephemeralContainers = new ArrayList<EphemeralContainerBuilder>();
  private ArrayList<HostAliasBuilder> hostAliases = new ArrayList<HostAliasBuilder>();
  private Boolean hostIPC;
  private Boolean hostNetwork;
  private Boolean hostPID;
  private Boolean hostUsers;
  private String hostname;
  private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();
  private ArrayList<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
  private String nodeName;
  private Map<String,String> nodeSelector;
  private PodOSBuilder os;
  private Map<String,Quantity> overhead;
  private String preemptionPolicy;
  private Integer priority;
  private String priorityClassName;
  private ArrayList<PodReadinessGateBuilder> readinessGates = new ArrayList<PodReadinessGateBuilder>();
  private ArrayList<PodResourceClaimBuilder> resourceClaims = new ArrayList<PodResourceClaimBuilder>();
  private String restartPolicy;
  private String runtimeClassName;
  private String schedulerName;
  private ArrayList<PodSchedulingGateBuilder> schedulingGates = new ArrayList<PodSchedulingGateBuilder>();
  private PodSecurityContextBuilder securityContext;
  private String serviceAccount;
  private String serviceAccountName;
  private Boolean setHostnameAsFQDN;
  private Boolean shareProcessNamespace;
  private String subdomain;
  private Long terminationGracePeriodSeconds;
  private ArrayList<TolerationBuilder> tolerations = new ArrayList<TolerationBuilder>();
  private ArrayList<TopologySpreadConstraintBuilder> topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>();
  private ArrayList<VolumeBuilder> volumes = new ArrayList<VolumeBuilder>();
  private Map<String,Object> additionalProperties;
  public Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
  }
  public Boolean hasActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds != null;
  }
  
  /**
   * This method has been deprecated, please use method buildAffinity instead.
   * @return The buildable object.
   */
  @Deprecated
  public Affinity getAffinity() {
    return this.affinity!=null ?this.affinity.build():null;
  }
  public Affinity buildAffinity() {
    return this.affinity!=null ?this.affinity.build():null;
  }
  public A withAffinity(Affinity affinity) {
    _visitables.get("affinity").remove(this.affinity);
    if (affinity!=null){ this.affinity= new AffinityBuilder(affinity); _visitables.get("affinity").add(this.affinity);} else { this.affinity = null; _visitables.get("affinity").remove(this.affinity); } return (A) this;
  }
  public Boolean hasAffinity() {
    return this.affinity != null;
  }
  public PodSpecFluent.AffinityNested<A> withNewAffinity() {
    return new PodSpecFluentImpl.AffinityNestedImpl();
  }
  public PodSpecFluent.AffinityNested<A> withNewAffinityLike(Affinity item) {
    return new PodSpecFluentImpl.AffinityNestedImpl(item);
  }
  public PodSpecFluent.AffinityNested<A> editAffinity() {
    return withNewAffinityLike(getAffinity());
  }
  public PodSpecFluent.AffinityNested<A> editOrNewAffinity() {
    return withNewAffinityLike(getAffinity() != null ? getAffinity(): new AffinityBuilder().build());
  }
  public PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(Affinity item) {
    return withNewAffinityLike(getAffinity() != null ? getAffinity(): item);
  }
  public Boolean getAutomountServiceAccountToken() {
    return this.automountServiceAccountToken;
  }
  public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
    this.automountServiceAccountToken=automountServiceAccountToken; return (A) this;
  }
  public Boolean hasAutomountServiceAccountToken() {
    return this.automountServiceAccountToken != null;
  }
  public A addToContainers(Integer index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(index >= 0 ? index : _visitables.get("containers").size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
  }
  public A setToContainers(Integer index,Container item) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("containers").size()) { _visitables.get("containers").add(builder); } else { _visitables.get("containers").set(index, builder);}
    if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
     return (A)this;
  }
  public A addToContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A addAllToContainers(Collection<Container> items) {
    if (this.containers == null) {this.containers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").add(builder);this.containers.add(builder);} return (A)this;
  }
  public A removeFromContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeAllFromContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("containers").remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
    if (containers == null) return (A) this;
    final Iterator<ContainerBuilder> each = containers.iterator();
    final List visitables = _visitables.get("containers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getContainers() {
    return containers != null ? build(containers) : null;
  }
  public List<Container> buildContainers() {
    return containers != null ? build(containers) : null;
  }
  public Container buildContainer(Integer index) {
    return this.containers.get(index).build();
  }
  public Container buildFirstContainer() {
    return this.containers.get(0).build();
  }
  public Container buildLastContainer() {
    return this.containers.get(containers.size() - 1).build();
  }
  public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: containers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withContainers(List<Container> containers) {
    if (this.containers != null) { _visitables.get("containers").removeAll(this.containers);}
    if (containers != null) {this.containers = new ArrayList(); for (Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
  }
  public A withContainers(io.fabric8.kubernetes.api.model.Container... containers) {
    if (this.containers != null) {this.containers.clear();}
    if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
  }
  public Boolean hasContainers() {
    return containers != null && !containers.isEmpty();
  }
  public PodSpecFluent.ContainersNested<A> addNewContainer() {
    return new PodSpecFluentImpl.ContainersNestedImpl();
  }
  public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
    return new PodSpecFluentImpl.ContainersNestedImpl(-1, item);
  }
  public PodSpecFluent.ContainersNested<A> setNewContainerLike(Integer index,Container item) {
    return new PodSpecFluentImpl.ContainersNestedImpl(index, item);
  }
  public PodSpecFluent.ContainersNested<A> editContainer(Integer index) {
    if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public PodSpecFluent.ContainersNested<A> editFirstContainer() {
    if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
    return setNewContainerLike(0, buildContainer(0));
  }
  public PodSpecFluent.ContainersNested<A> editLastContainer() {
    int index = containers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
    return setNewContainerLike(index, buildContainer(index));
  }
  public PodSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<containers.size();i++) { 
    if (predicate.test(containers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
    return setNewContainerLike(index, buildContainer(index));
  }
  
  /**
   * This method has been deprecated, please use method buildDnsConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodDNSConfig getDnsConfig() {
    return this.dnsConfig!=null ?this.dnsConfig.build():null;
  }
  public PodDNSConfig buildDnsConfig() {
    return this.dnsConfig!=null ?this.dnsConfig.build():null;
  }
  public A withDnsConfig(PodDNSConfig dnsConfig) {
    _visitables.get("dnsConfig").remove(this.dnsConfig);
    if (dnsConfig!=null){ this.dnsConfig= new PodDNSConfigBuilder(dnsConfig); _visitables.get("dnsConfig").add(this.dnsConfig);} else { this.dnsConfig = null; _visitables.get("dnsConfig").remove(this.dnsConfig); } return (A) this;
  }
  public Boolean hasDnsConfig() {
    return this.dnsConfig != null;
  }
  public PodSpecFluent.DnsConfigNested<A> withNewDnsConfig() {
    return new PodSpecFluentImpl.DnsConfigNestedImpl();
  }
  public PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(PodDNSConfig item) {
    return new PodSpecFluentImpl.DnsConfigNestedImpl(item);
  }
  public PodSpecFluent.DnsConfigNested<A> editDnsConfig() {
    return withNewDnsConfigLike(getDnsConfig());
  }
  public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig() {
    return withNewDnsConfigLike(getDnsConfig() != null ? getDnsConfig(): new PodDNSConfigBuilder().build());
  }
  public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(PodDNSConfig item) {
    return withNewDnsConfigLike(getDnsConfig() != null ? getDnsConfig(): item);
  }
  public String getDnsPolicy() {
    return this.dnsPolicy;
  }
  public A withDnsPolicy(String dnsPolicy) {
    this.dnsPolicy=dnsPolicy; return (A) this;
  }
  public Boolean hasDnsPolicy() {
    return this.dnsPolicy != null;
  }
  public Boolean getEnableServiceLinks() {
    return this.enableServiceLinks;
  }
  public A withEnableServiceLinks(Boolean enableServiceLinks) {
    this.enableServiceLinks=enableServiceLinks; return (A) this;
  }
  public Boolean hasEnableServiceLinks() {
    return this.enableServiceLinks != null;
  }
  public A addToEphemeralContainers(Integer index,EphemeralContainer item) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainerBuilder>();}
    EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").add(index >= 0 ? index : _visitables.get("ephemeralContainers").size(), builder);this.ephemeralContainers.add(index >= 0 ? index : ephemeralContainers.size(), builder); return (A)this;
  }
  public A setToEphemeralContainers(Integer index,EphemeralContainer item) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainerBuilder>();}
    EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("ephemeralContainers").size()) { _visitables.get("ephemeralContainers").add(builder); } else { _visitables.get("ephemeralContainers").set(index, builder);}
    if (index < 0 || index >= ephemeralContainers.size()) { ephemeralContainers.add(builder); } else { ephemeralContainers.set(index, builder);}
     return (A)this;
  }
  public A addToEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainerBuilder>();}
    for (EphemeralContainer item : items) {EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").add(builder);this.ephemeralContainers.add(builder);} return (A)this;
  }
  public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
    if (this.ephemeralContainers == null) {this.ephemeralContainers = new ArrayList<EphemeralContainerBuilder>();}
    for (EphemeralContainer item : items) {EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").add(builder);this.ephemeralContainers.add(builder);} return (A)this;
  }
  public A removeFromEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... items) {
    for (EphemeralContainer item : items) {EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").remove(builder);if (this.ephemeralContainers != null) {this.ephemeralContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
    for (EphemeralContainer item : items) {EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);_visitables.get("ephemeralContainers").remove(builder);if (this.ephemeralContainers != null) {this.ephemeralContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEphemeralContainers(Predicate<EphemeralContainerBuilder> predicate) {
    if (ephemeralContainers == null) return (A) this;
    final Iterator<EphemeralContainerBuilder> each = ephemeralContainers.iterator();
    final List visitables = _visitables.get("ephemeralContainers");
    while (each.hasNext()) {
      EphemeralContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEphemeralContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<EphemeralContainer> getEphemeralContainers() {
    return ephemeralContainers != null ? build(ephemeralContainers) : null;
  }
  public List<EphemeralContainer> buildEphemeralContainers() {
    return ephemeralContainers != null ? build(ephemeralContainers) : null;
  }
  public EphemeralContainer buildEphemeralContainer(Integer index) {
    return this.ephemeralContainers.get(index).build();
  }
  public EphemeralContainer buildFirstEphemeralContainer() {
    return this.ephemeralContainers.get(0).build();
  }
  public EphemeralContainer buildLastEphemeralContainer() {
    return this.ephemeralContainers.get(ephemeralContainers.size() - 1).build();
  }
  public EphemeralContainer buildMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
    for (EphemeralContainerBuilder item: ephemeralContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
    for (EphemeralContainerBuilder item: ephemeralContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
    if (this.ephemeralContainers != null) { _visitables.get("ephemeralContainers").removeAll(this.ephemeralContainers);}
    if (ephemeralContainers != null) {this.ephemeralContainers = new ArrayList(); for (EphemeralContainer item : ephemeralContainers){this.addToEphemeralContainers(item);}} else { this.ephemeralContainers = null;} return (A) this;
  }
  public A withEphemeralContainers(io.fabric8.kubernetes.api.model.EphemeralContainer... ephemeralContainers) {
    if (this.ephemeralContainers != null) {this.ephemeralContainers.clear();}
    if (ephemeralContainers != null) {for (EphemeralContainer item :ephemeralContainers){ this.addToEphemeralContainers(item);}} return (A) this;
  }
  public Boolean hasEphemeralContainers() {
    return ephemeralContainers != null && !ephemeralContainers.isEmpty();
  }
  public PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainer() {
    return new PodSpecFluentImpl.EphemeralContainersNestedImpl();
  }
  public PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainerLike(EphemeralContainer item) {
    return new PodSpecFluentImpl.EphemeralContainersNestedImpl(-1, item);
  }
  public PodSpecFluent.EphemeralContainersNested<A> setNewEphemeralContainerLike(Integer index,EphemeralContainer item) {
    return new PodSpecFluentImpl.EphemeralContainersNestedImpl(index, item);
  }
  public PodSpecFluent.EphemeralContainersNested<A> editEphemeralContainer(Integer index) {
    if (ephemeralContainers.size() <= index) throw new RuntimeException("Can't edit ephemeralContainers. Index exceeds size.");
    return setNewEphemeralContainerLike(index, buildEphemeralContainer(index));
  }
  public PodSpecFluent.EphemeralContainersNested<A> editFirstEphemeralContainer() {
    if (ephemeralContainers.size() == 0) throw new RuntimeException("Can't edit first ephemeralContainers. The list is empty.");
    return setNewEphemeralContainerLike(0, buildEphemeralContainer(0));
  }
  public PodSpecFluent.EphemeralContainersNested<A> editLastEphemeralContainer() {
    int index = ephemeralContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ephemeralContainers. The list is empty.");
    return setNewEphemeralContainerLike(index, buildEphemeralContainer(index));
  }
  public PodSpecFluent.EphemeralContainersNested<A> editMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ephemeralContainers.size();i++) { 
    if (predicate.test(ephemeralContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ephemeralContainers. No match found.");
    return setNewEphemeralContainerLike(index, buildEphemeralContainer(index));
  }
  public A addToHostAliases(Integer index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(index >= 0 ? index : _visitables.get("hostAliases").size(), builder);this.hostAliases.add(index >= 0 ? index : hostAliases.size(), builder); return (A)this;
  }
  public A setToHostAliases(Integer index,HostAlias item) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    HostAliasBuilder builder = new HostAliasBuilder(item);
    if (index < 0 || index >= _visitables.get("hostAliases").size()) { _visitables.get("hostAliases").add(builder); } else { _visitables.get("hostAliases").set(index, builder);}
    if (index < 0 || index >= hostAliases.size()) { hostAliases.add(builder); } else { hostAliases.set(index, builder);}
     return (A)this;
  }
  public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(builder);this.hostAliases.add(builder);} return (A)this;
  }
  public A addAllToHostAliases(Collection<HostAlias> items) {
    if (this.hostAliases == null) {this.hostAliases = new ArrayList<HostAliasBuilder>();}
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").add(builder);this.hostAliases.add(builder);} return (A)this;
  }
  public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").remove(builder);if (this.hostAliases != null) {this.hostAliases.remove(builder);}} return (A)this;
  }
  public A removeAllFromHostAliases(Collection<HostAlias> items) {
    for (HostAlias item : items) {HostAliasBuilder builder = new HostAliasBuilder(item);_visitables.get("hostAliases").remove(builder);if (this.hostAliases != null) {this.hostAliases.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate) {
    if (hostAliases == null) return (A) this;
    final Iterator<HostAliasBuilder> each = hostAliases.iterator();
    final List visitables = _visitables.get("hostAliases");
    while (each.hasNext()) {
      HostAliasBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildHostAliases instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HostAlias> getHostAliases() {
    return hostAliases != null ? build(hostAliases) : null;
  }
  public List<HostAlias> buildHostAliases() {
    return hostAliases != null ? build(hostAliases) : null;
  }
  public HostAlias buildHostAlias(Integer index) {
    return this.hostAliases.get(index).build();
  }
  public HostAlias buildFirstHostAlias() {
    return this.hostAliases.get(0).build();
  }
  public HostAlias buildLastHostAlias() {
    return this.hostAliases.get(hostAliases.size() - 1).build();
  }
  public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
    for (HostAliasBuilder item: hostAliases) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
    for (HostAliasBuilder item: hostAliases) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHostAliases(List<HostAlias> hostAliases) {
    if (this.hostAliases != null) { _visitables.get("hostAliases").removeAll(this.hostAliases);}
    if (hostAliases != null) {this.hostAliases = new ArrayList(); for (HostAlias item : hostAliases){this.addToHostAliases(item);}} else { this.hostAliases = null;} return (A) this;
  }
  public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases) {
    if (this.hostAliases != null) {this.hostAliases.clear();}
    if (hostAliases != null) {for (HostAlias item :hostAliases){ this.addToHostAliases(item);}} return (A) this;
  }
  public Boolean hasHostAliases() {
    return hostAliases != null && !hostAliases.isEmpty();
  }
  public PodSpecFluent.HostAliasesNested<A> addNewHostAlias() {
    return new PodSpecFluentImpl.HostAliasesNestedImpl();
  }
  public PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
    return new PodSpecFluentImpl.HostAliasesNestedImpl(-1, item);
  }
  public PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(Integer index,HostAlias item) {
    return new PodSpecFluentImpl.HostAliasesNestedImpl(index, item);
  }
  public PodSpecFluent.HostAliasesNested<A> editHostAlias(Integer index) {
    if (hostAliases.size() <= index) throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
    return setNewHostAliasLike(index, buildHostAlias(index));
  }
  public PodSpecFluent.HostAliasesNested<A> editFirstHostAlias() {
    if (hostAliases.size() == 0) throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
    return setNewHostAliasLike(0, buildHostAlias(0));
  }
  public PodSpecFluent.HostAliasesNested<A> editLastHostAlias() {
    int index = hostAliases.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
    return setNewHostAliasLike(index, buildHostAlias(index));
  }
  public PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hostAliases.size();i++) { 
    if (predicate.test(hostAliases.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hostAliases. No match found.");
    return setNewHostAliasLike(index, buildHostAlias(index));
  }
  public Boolean getHostIPC() {
    return this.hostIPC;
  }
  public A withHostIPC(Boolean hostIPC) {
    this.hostIPC=hostIPC; return (A) this;
  }
  public Boolean hasHostIPC() {
    return this.hostIPC != null;
  }
  public Boolean getHostNetwork() {
    return this.hostNetwork;
  }
  public A withHostNetwork(Boolean hostNetwork) {
    this.hostNetwork=hostNetwork; return (A) this;
  }
  public Boolean hasHostNetwork() {
    return this.hostNetwork != null;
  }
  public Boolean getHostPID() {
    return this.hostPID;
  }
  public A withHostPID(Boolean hostPID) {
    this.hostPID=hostPID; return (A) this;
  }
  public Boolean hasHostPID() {
    return this.hostPID != null;
  }
  public Boolean getHostUsers() {
    return this.hostUsers;
  }
  public A withHostUsers(Boolean hostUsers) {
    this.hostUsers=hostUsers; return (A) this;
  }
  public Boolean hasHostUsers() {
    return this.hostUsers != null;
  }
  public String getHostname() {
    return this.hostname;
  }
  public A withHostname(String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public Boolean hasHostname() {
    return this.hostname != null;
  }
  public A addToImagePullSecrets(Integer index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(index >= 0 ? index : _visitables.get("imagePullSecrets").size(), builder);this.imagePullSecrets.add(index >= 0 ? index : imagePullSecrets.size(), builder); return (A)this;
  }
  public A setToImagePullSecrets(Integer index,LocalObjectReference item) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("imagePullSecrets").size()) { _visitables.get("imagePullSecrets").add(builder); } else { _visitables.get("imagePullSecrets").set(index, builder);}
    if (index < 0 || index >= imagePullSecrets.size()) { imagePullSecrets.add(builder); } else { imagePullSecrets.set(index, builder);}
     return (A)this;
  }
  public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
    if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").add(builder);this.imagePullSecrets.add(builder);} return (A)this;
  }
  public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("imagePullSecrets").remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (imagePullSecrets == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = imagePullSecrets.iterator();
    final List visitables = _visitables.get("imagePullSecrets");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImagePullSecrets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LocalObjectReference> getImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public List<LocalObjectReference> buildImagePullSecrets() {
    return imagePullSecrets != null ? build(imagePullSecrets) : null;
  }
  public LocalObjectReference buildImagePullSecret(Integer index) {
    return this.imagePullSecrets.get(index).build();
  }
  public LocalObjectReference buildFirstImagePullSecret() {
    return this.imagePullSecrets.get(0).build();
  }
  public LocalObjectReference buildLastImagePullSecret() {
    return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
  }
  public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
    if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
    if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList(); for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
  }
  public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
    if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
    if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
  }
  public Boolean hasImagePullSecrets() {
    return imagePullSecrets != null && !imagePullSecrets.isEmpty();
  }
  public A addNewImagePullSecret(String name) {
    return (A)addToImagePullSecrets(new LocalObjectReference(name));
  }
  public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
    return new PodSpecFluentImpl.ImagePullSecretsNestedImpl();
  }
  public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
    return new PodSpecFluentImpl.ImagePullSecretsNestedImpl(-1, item);
  }
  public PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(Integer index,LocalObjectReference item) {
    return new PodSpecFluentImpl.ImagePullSecretsNestedImpl(index, item);
  }
  public PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(Integer index) {
    if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
    if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(0, buildImagePullSecret(0));
  }
  public PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
    int index = imagePullSecrets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imagePullSecrets.size();i++) { 
    if (predicate.test(imagePullSecrets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
    return setNewImagePullSecretLike(index, buildImagePullSecret(index));
  }
  public A addToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
  }
  public A setToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
    if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(Collection<Container> items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.fabric8.kubernetes.api.model.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Container> getInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public List<Container> buildInitContainers() {
    return initContainers != null ? build(initContainers) : null;
  }
  public Container buildInitContainer(Integer index) {
    return this.initContainers.get(index).build();
  }
  public Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInitContainers(List<Container> initContainers) {
    if (this.initContainers != null) { _visitables.get("initContainers").removeAll(this.initContainers);}
    if (initContainers != null) {this.initContainers = new ArrayList(); for (Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
  }
  public A withInitContainers(io.fabric8.kubernetes.api.model.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear();}
    if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  public Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public PodSpecFluent.InitContainersNested<A> addNewInitContainer() {
    return new PodSpecFluentImpl.InitContainersNestedImpl();
  }
  public PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
    return new PodSpecFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item) {
    return new PodSpecFluentImpl.InitContainersNestedImpl(index, item);
  }
  public PodSpecFluent.InitContainersNested<A> editInitContainer(Integer index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public PodSpecFluent.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public PodSpecFluent.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public String getNodeName() {
    return this.nodeName;
  }
  public A withNodeName(String nodeName) {
    this.nodeName=nodeName; return (A) this;
  }
  public Boolean hasNodeName() {
    return this.nodeName != null;
  }
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap(nodeSelector);} return (A) this;
  }
  public Boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  /**
   * This method has been deprecated, please use method buildOs instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodOS getOs() {
    return this.os!=null ?this.os.build():null;
  }
  public PodOS buildOs() {
    return this.os!=null ?this.os.build():null;
  }
  public A withOs(PodOS os) {
    _visitables.get("os").remove(this.os);
    if (os!=null){ this.os= new PodOSBuilder(os); _visitables.get("os").add(this.os);} else { this.os = null; _visitables.get("os").remove(this.os); } return (A) this;
  }
  public Boolean hasOs() {
    return this.os != null;
  }
  public A withNewOs(String name) {
    return (A)withOs(new PodOS(name));
  }
  public PodSpecFluent.OsNested<A> withNewOs() {
    return new PodSpecFluentImpl.OsNestedImpl();
  }
  public PodSpecFluent.OsNested<A> withNewOsLike(PodOS item) {
    return new PodSpecFluentImpl.OsNestedImpl(item);
  }
  public PodSpecFluent.OsNested<A> editOs() {
    return withNewOsLike(getOs());
  }
  public PodSpecFluent.OsNested<A> editOrNewOs() {
    return withNewOsLike(getOs() != null ? getOs(): new PodOSBuilder().build());
  }
  public PodSpecFluent.OsNested<A> editOrNewOsLike(PodOS item) {
    return withNewOsLike(getOs() != null ? getOs(): item);
  }
  public A addToOverhead(String key,Quantity value) {
    if(this.overhead == null && key != null && value != null) { this.overhead = new LinkedHashMap(); }
    if(key != null && value != null) {this.overhead.put(key, value);} return (A)this;
  }
  public A addToOverhead(Map<String,Quantity> map) {
    if(this.overhead == null && map != null) { this.overhead = new LinkedHashMap(); }
    if(map != null) { this.overhead.putAll(map);} return (A)this;
  }
  public A removeFromOverhead(String key) {
    if(this.overhead == null) { return (A) this; }
    if(key != null && this.overhead != null) {this.overhead.remove(key);} return (A)this;
  }
  public A removeFromOverhead(Map<String,Quantity> map) {
    if(this.overhead == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.overhead != null){this.overhead.remove(key);}}} return (A)this;
  }
  public Map<String,Quantity> getOverhead() {
    return this.overhead;
  }
  public <K,V>A withOverhead(Map<String,Quantity> overhead) {
    if (overhead == null) { this.overhead =  null;} else {this.overhead = new LinkedHashMap(overhead);} return (A) this;
  }
  public Boolean hasOverhead() {
    return this.overhead != null;
  }
  public String getPreemptionPolicy() {
    return this.preemptionPolicy;
  }
  public A withPreemptionPolicy(String preemptionPolicy) {
    this.preemptionPolicy=preemptionPolicy; return (A) this;
  }
  public Boolean hasPreemptionPolicy() {
    return this.preemptionPolicy != null;
  }
  public Integer getPriority() {
    return this.priority;
  }
  public A withPriority(Integer priority) {
    this.priority=priority; return (A) this;
  }
  public Boolean hasPriority() {
    return this.priority != null;
  }
  public String getPriorityClassName() {
    return this.priorityClassName;
  }
  public A withPriorityClassName(String priorityClassName) {
    this.priorityClassName=priorityClassName; return (A) this;
  }
  public Boolean hasPriorityClassName() {
    return this.priorityClassName != null;
  }
  public A addToReadinessGates(Integer index,PodReadinessGate item) {
    if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGateBuilder>();}
    PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").add(index >= 0 ? index : _visitables.get("readinessGates").size(), builder);this.readinessGates.add(index >= 0 ? index : readinessGates.size(), builder); return (A)this;
  }
  public A setToReadinessGates(Integer index,PodReadinessGate item) {
    if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGateBuilder>();}
    PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
    if (index < 0 || index >= _visitables.get("readinessGates").size()) { _visitables.get("readinessGates").add(builder); } else { _visitables.get("readinessGates").set(index, builder);}
    if (index < 0 || index >= readinessGates.size()) { readinessGates.add(builder); } else { readinessGates.set(index, builder);}
     return (A)this;
  }
  public A addToReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items) {
    if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGateBuilder>();}
    for (PodReadinessGate item : items) {PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").add(builder);this.readinessGates.add(builder);} return (A)this;
  }
  public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
    if (this.readinessGates == null) {this.readinessGates = new ArrayList<PodReadinessGateBuilder>();}
    for (PodReadinessGate item : items) {PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").add(builder);this.readinessGates.add(builder);} return (A)this;
  }
  public A removeFromReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... items) {
    for (PodReadinessGate item : items) {PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").remove(builder);if (this.readinessGates != null) {this.readinessGates.remove(builder);}} return (A)this;
  }
  public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
    for (PodReadinessGate item : items) {PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);_visitables.get("readinessGates").remove(builder);if (this.readinessGates != null) {this.readinessGates.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromReadinessGates(Predicate<PodReadinessGateBuilder> predicate) {
    if (readinessGates == null) return (A) this;
    final Iterator<PodReadinessGateBuilder> each = readinessGates.iterator();
    final List visitables = _visitables.get("readinessGates");
    while (each.hasNext()) {
      PodReadinessGateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildReadinessGates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodReadinessGate> getReadinessGates() {
    return readinessGates != null ? build(readinessGates) : null;
  }
  public List<PodReadinessGate> buildReadinessGates() {
    return readinessGates != null ? build(readinessGates) : null;
  }
  public PodReadinessGate buildReadinessGate(Integer index) {
    return this.readinessGates.get(index).build();
  }
  public PodReadinessGate buildFirstReadinessGate() {
    return this.readinessGates.get(0).build();
  }
  public PodReadinessGate buildLastReadinessGate() {
    return this.readinessGates.get(readinessGates.size() - 1).build();
  }
  public PodReadinessGate buildMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
    for (PodReadinessGateBuilder item: readinessGates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
    for (PodReadinessGateBuilder item: readinessGates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withReadinessGates(List<PodReadinessGate> readinessGates) {
    if (this.readinessGates != null) { _visitables.get("readinessGates").removeAll(this.readinessGates);}
    if (readinessGates != null) {this.readinessGates = new ArrayList(); for (PodReadinessGate item : readinessGates){this.addToReadinessGates(item);}} else { this.readinessGates = null;} return (A) this;
  }
  public A withReadinessGates(io.fabric8.kubernetes.api.model.PodReadinessGate... readinessGates) {
    if (this.readinessGates != null) {this.readinessGates.clear();}
    if (readinessGates != null) {for (PodReadinessGate item :readinessGates){ this.addToReadinessGates(item);}} return (A) this;
  }
  public Boolean hasReadinessGates() {
    return readinessGates != null && !readinessGates.isEmpty();
  }
  public A addNewReadinessGate(String conditionType) {
    return (A)addToReadinessGates(new PodReadinessGate(conditionType));
  }
  public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate() {
    return new PodSpecFluentImpl.ReadinessGatesNestedImpl();
  }
  public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(PodReadinessGate item) {
    return new PodSpecFluentImpl.ReadinessGatesNestedImpl(-1, item);
  }
  public PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(Integer index,PodReadinessGate item) {
    return new PodSpecFluentImpl.ReadinessGatesNestedImpl(index, item);
  }
  public PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(Integer index) {
    if (readinessGates.size() <= index) throw new RuntimeException("Can't edit readinessGates. Index exceeds size.");
    return setNewReadinessGateLike(index, buildReadinessGate(index));
  }
  public PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate() {
    if (readinessGates.size() == 0) throw new RuntimeException("Can't edit first readinessGates. The list is empty.");
    return setNewReadinessGateLike(0, buildReadinessGate(0));
  }
  public PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate() {
    int index = readinessGates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last readinessGates. The list is empty.");
    return setNewReadinessGateLike(index, buildReadinessGate(index));
  }
  public PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<readinessGates.size();i++) { 
    if (predicate.test(readinessGates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching readinessGates. No match found.");
    return setNewReadinessGateLike(index, buildReadinessGate(index));
  }
  public A addToResourceClaims(Integer index,PodResourceClaim item) {
    if (this.resourceClaims == null) {this.resourceClaims = new ArrayList<PodResourceClaimBuilder>();}
    PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);_visitables.get("resourceClaims").add(index >= 0 ? index : _visitables.get("resourceClaims").size(), builder);this.resourceClaims.add(index >= 0 ? index : resourceClaims.size(), builder); return (A)this;
  }
  public A setToResourceClaims(Integer index,PodResourceClaim item) {
    if (this.resourceClaims == null) {this.resourceClaims = new ArrayList<PodResourceClaimBuilder>();}
    PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
    if (index < 0 || index >= _visitables.get("resourceClaims").size()) { _visitables.get("resourceClaims").add(builder); } else { _visitables.get("resourceClaims").set(index, builder);}
    if (index < 0 || index >= resourceClaims.size()) { resourceClaims.add(builder); } else { resourceClaims.set(index, builder);}
     return (A)this;
  }
  public A addToResourceClaims(io.fabric8.kubernetes.api.model.PodResourceClaim... items) {
    if (this.resourceClaims == null) {this.resourceClaims = new ArrayList<PodResourceClaimBuilder>();}
    for (PodResourceClaim item : items) {PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);_visitables.get("resourceClaims").add(builder);this.resourceClaims.add(builder);} return (A)this;
  }
  public A addAllToResourceClaims(Collection<PodResourceClaim> items) {
    if (this.resourceClaims == null) {this.resourceClaims = new ArrayList<PodResourceClaimBuilder>();}
    for (PodResourceClaim item : items) {PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);_visitables.get("resourceClaims").add(builder);this.resourceClaims.add(builder);} return (A)this;
  }
  public A removeFromResourceClaims(io.fabric8.kubernetes.api.model.PodResourceClaim... items) {
    for (PodResourceClaim item : items) {PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);_visitables.get("resourceClaims").remove(builder);if (this.resourceClaims != null) {this.resourceClaims.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceClaims(Collection<PodResourceClaim> items) {
    for (PodResourceClaim item : items) {PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);_visitables.get("resourceClaims").remove(builder);if (this.resourceClaims != null) {this.resourceClaims.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceClaims(Predicate<PodResourceClaimBuilder> predicate) {
    if (resourceClaims == null) return (A) this;
    final Iterator<PodResourceClaimBuilder> each = resourceClaims.iterator();
    final List visitables = _visitables.get("resourceClaims");
    while (each.hasNext()) {
      PodResourceClaimBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResourceClaims instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodResourceClaim> getResourceClaims() {
    return resourceClaims != null ? build(resourceClaims) : null;
  }
  public List<PodResourceClaim> buildResourceClaims() {
    return resourceClaims != null ? build(resourceClaims) : null;
  }
  public PodResourceClaim buildResourceClaim(Integer index) {
    return this.resourceClaims.get(index).build();
  }
  public PodResourceClaim buildFirstResourceClaim() {
    return this.resourceClaims.get(0).build();
  }
  public PodResourceClaim buildLastResourceClaim() {
    return this.resourceClaims.get(resourceClaims.size() - 1).build();
  }
  public PodResourceClaim buildMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate) {
    for (PodResourceClaimBuilder item: resourceClaims) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate) {
    for (PodResourceClaimBuilder item: resourceClaims) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceClaims(List<PodResourceClaim> resourceClaims) {
    if (this.resourceClaims != null) { _visitables.get("resourceClaims").removeAll(this.resourceClaims);}
    if (resourceClaims != null) {this.resourceClaims = new ArrayList(); for (PodResourceClaim item : resourceClaims){this.addToResourceClaims(item);}} else { this.resourceClaims = null;} return (A) this;
  }
  public A withResourceClaims(io.fabric8.kubernetes.api.model.PodResourceClaim... resourceClaims) {
    if (this.resourceClaims != null) {this.resourceClaims.clear();}
    if (resourceClaims != null) {for (PodResourceClaim item :resourceClaims){ this.addToResourceClaims(item);}} return (A) this;
  }
  public Boolean hasResourceClaims() {
    return resourceClaims != null && !resourceClaims.isEmpty();
  }
  public PodSpecFluent.ResourceClaimsNested<A> addNewResourceClaim() {
    return new PodSpecFluentImpl.ResourceClaimsNestedImpl();
  }
  public PodSpecFluent.ResourceClaimsNested<A> addNewResourceClaimLike(PodResourceClaim item) {
    return new PodSpecFluentImpl.ResourceClaimsNestedImpl(-1, item);
  }
  public PodSpecFluent.ResourceClaimsNested<A> setNewResourceClaimLike(Integer index,PodResourceClaim item) {
    return new PodSpecFluentImpl.ResourceClaimsNestedImpl(index, item);
  }
  public PodSpecFluent.ResourceClaimsNested<A> editResourceClaim(Integer index) {
    if (resourceClaims.size() <= index) throw new RuntimeException("Can't edit resourceClaims. Index exceeds size.");
    return setNewResourceClaimLike(index, buildResourceClaim(index));
  }
  public PodSpecFluent.ResourceClaimsNested<A> editFirstResourceClaim() {
    if (resourceClaims.size() == 0) throw new RuntimeException("Can't edit first resourceClaims. The list is empty.");
    return setNewResourceClaimLike(0, buildResourceClaim(0));
  }
  public PodSpecFluent.ResourceClaimsNested<A> editLastResourceClaim() {
    int index = resourceClaims.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceClaims. The list is empty.");
    return setNewResourceClaimLike(index, buildResourceClaim(index));
  }
  public PodSpecFluent.ResourceClaimsNested<A> editMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceClaims.size();i++) { 
    if (predicate.test(resourceClaims.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceClaims. No match found.");
    return setNewResourceClaimLike(index, buildResourceClaim(index));
  }
  public String getRestartPolicy() {
    return this.restartPolicy;
  }
  public A withRestartPolicy(String restartPolicy) {
    this.restartPolicy=restartPolicy; return (A) this;
  }
  public Boolean hasRestartPolicy() {
    return this.restartPolicy != null;
  }
  public String getRuntimeClassName() {
    return this.runtimeClassName;
  }
  public A withRuntimeClassName(String runtimeClassName) {
    this.runtimeClassName=runtimeClassName; return (A) this;
  }
  public Boolean hasRuntimeClassName() {
    return this.runtimeClassName != null;
  }
  public String getSchedulerName() {
    return this.schedulerName;
  }
  public A withSchedulerName(String schedulerName) {
    this.schedulerName=schedulerName; return (A) this;
  }
  public Boolean hasSchedulerName() {
    return this.schedulerName != null;
  }
  public A addToSchedulingGates(Integer index,PodSchedulingGate item) {
    if (this.schedulingGates == null) {this.schedulingGates = new ArrayList<PodSchedulingGateBuilder>();}
    PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);_visitables.get("schedulingGates").add(index >= 0 ? index : _visitables.get("schedulingGates").size(), builder);this.schedulingGates.add(index >= 0 ? index : schedulingGates.size(), builder); return (A)this;
  }
  public A setToSchedulingGates(Integer index,PodSchedulingGate item) {
    if (this.schedulingGates == null) {this.schedulingGates = new ArrayList<PodSchedulingGateBuilder>();}
    PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
    if (index < 0 || index >= _visitables.get("schedulingGates").size()) { _visitables.get("schedulingGates").add(builder); } else { _visitables.get("schedulingGates").set(index, builder);}
    if (index < 0 || index >= schedulingGates.size()) { schedulingGates.add(builder); } else { schedulingGates.set(index, builder);}
     return (A)this;
  }
  public A addToSchedulingGates(io.fabric8.kubernetes.api.model.PodSchedulingGate... items) {
    if (this.schedulingGates == null) {this.schedulingGates = new ArrayList<PodSchedulingGateBuilder>();}
    for (PodSchedulingGate item : items) {PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);_visitables.get("schedulingGates").add(builder);this.schedulingGates.add(builder);} return (A)this;
  }
  public A addAllToSchedulingGates(Collection<PodSchedulingGate> items) {
    if (this.schedulingGates == null) {this.schedulingGates = new ArrayList<PodSchedulingGateBuilder>();}
    for (PodSchedulingGate item : items) {PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);_visitables.get("schedulingGates").add(builder);this.schedulingGates.add(builder);} return (A)this;
  }
  public A removeFromSchedulingGates(io.fabric8.kubernetes.api.model.PodSchedulingGate... items) {
    for (PodSchedulingGate item : items) {PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);_visitables.get("schedulingGates").remove(builder);if (this.schedulingGates != null) {this.schedulingGates.remove(builder);}} return (A)this;
  }
  public A removeAllFromSchedulingGates(Collection<PodSchedulingGate> items) {
    for (PodSchedulingGate item : items) {PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);_visitables.get("schedulingGates").remove(builder);if (this.schedulingGates != null) {this.schedulingGates.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSchedulingGates(Predicate<PodSchedulingGateBuilder> predicate) {
    if (schedulingGates == null) return (A) this;
    final Iterator<PodSchedulingGateBuilder> each = schedulingGates.iterator();
    final List visitables = _visitables.get("schedulingGates");
    while (each.hasNext()) {
      PodSchedulingGateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSchedulingGates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PodSchedulingGate> getSchedulingGates() {
    return schedulingGates != null ? build(schedulingGates) : null;
  }
  public List<PodSchedulingGate> buildSchedulingGates() {
    return schedulingGates != null ? build(schedulingGates) : null;
  }
  public PodSchedulingGate buildSchedulingGate(Integer index) {
    return this.schedulingGates.get(index).build();
  }
  public PodSchedulingGate buildFirstSchedulingGate() {
    return this.schedulingGates.get(0).build();
  }
  public PodSchedulingGate buildLastSchedulingGate() {
    return this.schedulingGates.get(schedulingGates.size() - 1).build();
  }
  public PodSchedulingGate buildMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate) {
    for (PodSchedulingGateBuilder item: schedulingGates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate) {
    for (PodSchedulingGateBuilder item: schedulingGates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSchedulingGates(List<PodSchedulingGate> schedulingGates) {
    if (this.schedulingGates != null) { _visitables.get("schedulingGates").removeAll(this.schedulingGates);}
    if (schedulingGates != null) {this.schedulingGates = new ArrayList(); for (PodSchedulingGate item : schedulingGates){this.addToSchedulingGates(item);}} else { this.schedulingGates = null;} return (A) this;
  }
  public A withSchedulingGates(io.fabric8.kubernetes.api.model.PodSchedulingGate... schedulingGates) {
    if (this.schedulingGates != null) {this.schedulingGates.clear();}
    if (schedulingGates != null) {for (PodSchedulingGate item :schedulingGates){ this.addToSchedulingGates(item);}} return (A) this;
  }
  public Boolean hasSchedulingGates() {
    return schedulingGates != null && !schedulingGates.isEmpty();
  }
  public A addNewSchedulingGate(String name) {
    return (A)addToSchedulingGates(new PodSchedulingGate(name));
  }
  public PodSpecFluent.SchedulingGatesNested<A> addNewSchedulingGate() {
    return new PodSpecFluentImpl.SchedulingGatesNestedImpl();
  }
  public PodSpecFluent.SchedulingGatesNested<A> addNewSchedulingGateLike(PodSchedulingGate item) {
    return new PodSpecFluentImpl.SchedulingGatesNestedImpl(-1, item);
  }
  public PodSpecFluent.SchedulingGatesNested<A> setNewSchedulingGateLike(Integer index,PodSchedulingGate item) {
    return new PodSpecFluentImpl.SchedulingGatesNestedImpl(index, item);
  }
  public PodSpecFluent.SchedulingGatesNested<A> editSchedulingGate(Integer index) {
    if (schedulingGates.size() <= index) throw new RuntimeException("Can't edit schedulingGates. Index exceeds size.");
    return setNewSchedulingGateLike(index, buildSchedulingGate(index));
  }
  public PodSpecFluent.SchedulingGatesNested<A> editFirstSchedulingGate() {
    if (schedulingGates.size() == 0) throw new RuntimeException("Can't edit first schedulingGates. The list is empty.");
    return setNewSchedulingGateLike(0, buildSchedulingGate(0));
  }
  public PodSpecFluent.SchedulingGatesNested<A> editLastSchedulingGate() {
    int index = schedulingGates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last schedulingGates. The list is empty.");
    return setNewSchedulingGateLike(index, buildSchedulingGate(index));
  }
  public PodSpecFluent.SchedulingGatesNested<A> editMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<schedulingGates.size();i++) { 
    if (predicate.test(schedulingGates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching schedulingGates. No match found.");
    return setNewSchedulingGateLike(index, buildSchedulingGate(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSecurityContext instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodSecurityContext getSecurityContext() {
    return this.securityContext!=null ?this.securityContext.build():null;
  }
  public PodSecurityContext buildSecurityContext() {
    return this.securityContext!=null ?this.securityContext.build():null;
  }
  public A withSecurityContext(PodSecurityContext securityContext) {
    _visitables.get("securityContext").remove(this.securityContext);
    if (securityContext!=null){ this.securityContext= new PodSecurityContextBuilder(securityContext); _visitables.get("securityContext").add(this.securityContext);} else { this.securityContext = null; _visitables.get("securityContext").remove(this.securityContext); } return (A) this;
  }
  public Boolean hasSecurityContext() {
    return this.securityContext != null;
  }
  public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext() {
    return new PodSpecFluentImpl.SecurityContextNestedImpl();
  }
  public PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item) {
    return new PodSpecFluentImpl.SecurityContextNestedImpl(item);
  }
  public PodSpecFluent.SecurityContextNested<A> editSecurityContext() {
    return withNewSecurityContextLike(getSecurityContext());
  }
  public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext() {
    return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): new PodSecurityContextBuilder().build());
  }
  public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(PodSecurityContext item) {
    return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): item);
  }
  public String getServiceAccount() {
    return this.serviceAccount;
  }
  public A withServiceAccount(String serviceAccount) {
    this.serviceAccount=serviceAccount; return (A) this;
  }
  public Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  public Boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  public Boolean getSetHostnameAsFQDN() {
    return this.setHostnameAsFQDN;
  }
  public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN) {
    this.setHostnameAsFQDN=setHostnameAsFQDN; return (A) this;
  }
  public Boolean hasSetHostnameAsFQDN() {
    return this.setHostnameAsFQDN != null;
  }
  public Boolean getShareProcessNamespace() {
    return this.shareProcessNamespace;
  }
  public A withShareProcessNamespace(Boolean shareProcessNamespace) {
    this.shareProcessNamespace=shareProcessNamespace; return (A) this;
  }
  public Boolean hasShareProcessNamespace() {
    return this.shareProcessNamespace != null;
  }
  public String getSubdomain() {
    return this.subdomain;
  }
  public A withSubdomain(String subdomain) {
    this.subdomain=subdomain; return (A) this;
  }
  public Boolean hasSubdomain() {
    return this.subdomain != null;
  }
  public Long getTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds;
  }
  public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
    this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
  }
  public Boolean hasTerminationGracePeriodSeconds() {
    return this.terminationGracePeriodSeconds != null;
  }
  public A addToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
    TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").add(index >= 0 ? index : _visitables.get("tolerations").size(), builder);this.tolerations.add(index >= 0 ? index : tolerations.size(), builder); return (A)this;
  }
  public A setToTolerations(Integer index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
    TolerationBuilder builder = new TolerationBuilder(item);
    if (index < 0 || index >= _visitables.get("tolerations").size()) { _visitables.get("tolerations").add(builder); } else { _visitables.get("tolerations").set(index, builder);}
    if (index < 0 || index >= tolerations.size()) { tolerations.add(builder); } else { tolerations.set(index, builder);}
     return (A)this;
  }
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
    for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").add(builder);this.tolerations.add(builder);} return (A)this;
  }
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<TolerationBuilder>();}
    for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").add(builder);this.tolerations.add(builder);} return (A)this;
  }
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").remove(builder);if (this.tolerations != null) {this.tolerations.remove(builder);}} return (A)this;
  }
  public A removeAllFromTolerations(Collection<Toleration> items) {
    for (Toleration item : items) {TolerationBuilder builder = new TolerationBuilder(item);_visitables.get("tolerations").remove(builder);if (this.tolerations != null) {this.tolerations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTolerations(Predicate<TolerationBuilder> predicate) {
    if (tolerations == null) return (A) this;
    final Iterator<TolerationBuilder> each = tolerations.iterator();
    final List visitables = _visitables.get("tolerations");
    while (each.hasNext()) {
      TolerationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTolerations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Toleration> getTolerations() {
    return tolerations != null ? build(tolerations) : null;
  }
  public List<Toleration> buildTolerations() {
    return tolerations != null ? build(tolerations) : null;
  }
  public Toleration buildToleration(Integer index) {
    return this.tolerations.get(index).build();
  }
  public Toleration buildFirstToleration() {
    return this.tolerations.get(0).build();
  }
  public Toleration buildLastToleration() {
    return this.tolerations.get(tolerations.size() - 1).build();
  }
  public Toleration buildMatchingToleration(Predicate<TolerationBuilder> predicate) {
    for (TolerationBuilder item: tolerations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingToleration(Predicate<TolerationBuilder> predicate) {
    for (TolerationBuilder item: tolerations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTolerations(List<Toleration> tolerations) {
    if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
    if (tolerations != null) {this.tolerations = new ArrayList(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
  }
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear();}
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  public Boolean hasTolerations() {
    return tolerations != null && !tolerations.isEmpty();
  }
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  public PodSpecFluent.TolerationsNested<A> addNewToleration() {
    return new PodSpecFluentImpl.TolerationsNestedImpl();
  }
  public PodSpecFluent.TolerationsNested<A> addNewTolerationLike(Toleration item) {
    return new PodSpecFluentImpl.TolerationsNestedImpl(-1, item);
  }
  public PodSpecFluent.TolerationsNested<A> setNewTolerationLike(Integer index,Toleration item) {
    return new PodSpecFluentImpl.TolerationsNestedImpl(index, item);
  }
  public PodSpecFluent.TolerationsNested<A> editToleration(Integer index) {
    if (tolerations.size() <= index) throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
    return setNewTolerationLike(index, buildToleration(index));
  }
  public PodSpecFluent.TolerationsNested<A> editFirstToleration() {
    if (tolerations.size() == 0) throw new RuntimeException("Can't edit first tolerations. The list is empty.");
    return setNewTolerationLike(0, buildToleration(0));
  }
  public PodSpecFluent.TolerationsNested<A> editLastToleration() {
    int index = tolerations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tolerations. The list is empty.");
    return setNewTolerationLike(index, buildToleration(index));
  }
  public PodSpecFluent.TolerationsNested<A> editMatchingToleration(Predicate<TolerationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tolerations.size();i++) { 
    if (predicate.test(tolerations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tolerations. No match found.");
    return setNewTolerationLike(index, buildToleration(index));
  }
  public A addToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>();}
    TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").add(index >= 0 ? index : _visitables.get("topologySpreadConstraints").size(), builder);this.topologySpreadConstraints.add(index >= 0 ? index : topologySpreadConstraints.size(), builder); return (A)this;
  }
  public A setToTopologySpreadConstraints(Integer index,TopologySpreadConstraint item) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>();}
    TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
    if (index < 0 || index >= _visitables.get("topologySpreadConstraints").size()) { _visitables.get("topologySpreadConstraints").add(builder); } else { _visitables.get("topologySpreadConstraints").set(index, builder);}
    if (index < 0 || index >= topologySpreadConstraints.size()) { topologySpreadConstraints.add(builder); } else { topologySpreadConstraints.set(index, builder);}
     return (A)this;
  }
  public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>();}
    for (TopologySpreadConstraint item : items) {TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").add(builder);this.topologySpreadConstraints.add(builder);} return (A)this;
  }
  public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraintBuilder>();}
    for (TopologySpreadConstraint item : items) {TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").add(builder);this.topologySpreadConstraints.add(builder);} return (A)this;
  }
  public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
    for (TopologySpreadConstraint item : items) {TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").remove(builder);if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.remove(builder);}} return (A)this;
  }
  public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
    for (TopologySpreadConstraint item : items) {TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);_visitables.get("topologySpreadConstraints").remove(builder);if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTopologySpreadConstraints(Predicate<TopologySpreadConstraintBuilder> predicate) {
    if (topologySpreadConstraints == null) return (A) this;
    final Iterator<TopologySpreadConstraintBuilder> each = topologySpreadConstraints.iterator();
    final List visitables = _visitables.get("topologySpreadConstraints");
    while (each.hasNext()) {
      TopologySpreadConstraintBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTopologySpreadConstraints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
    return topologySpreadConstraints != null ? build(topologySpreadConstraints) : null;
  }
  public List<TopologySpreadConstraint> buildTopologySpreadConstraints() {
    return topologySpreadConstraints != null ? build(topologySpreadConstraints) : null;
  }
  public TopologySpreadConstraint buildTopologySpreadConstraint(Integer index) {
    return this.topologySpreadConstraints.get(index).build();
  }
  public TopologySpreadConstraint buildFirstTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(0).build();
  }
  public TopologySpreadConstraint buildLastTopologySpreadConstraint() {
    return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1).build();
  }
  public TopologySpreadConstraint buildMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
    for (TopologySpreadConstraintBuilder item: topologySpreadConstraints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
    for (TopologySpreadConstraintBuilder item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) { _visitables.get("topologySpreadConstraints").removeAll(this.topologySpreadConstraints);}
    if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new ArrayList(); for (TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
  }
  public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
    if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear();}
    if (topologySpreadConstraints != null) {for (TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
  }
  public Boolean hasTopologySpreadConstraints() {
    return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
  }
  public PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint() {
    return new PodSpecFluentImpl.TopologySpreadConstraintsNestedImpl();
  }
  public PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(TopologySpreadConstraint item) {
    return new PodSpecFluentImpl.TopologySpreadConstraintsNestedImpl(-1, item);
  }
  public PodSpecFluent.TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(Integer index,TopologySpreadConstraint item) {
    return new PodSpecFluentImpl.TopologySpreadConstraintsNestedImpl(index, item);
  }
  public PodSpecFluent.TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(Integer index) {
    if (topologySpreadConstraints.size() <= index) throw new RuntimeException("Can't edit topologySpreadConstraints. Index exceeds size.");
    return setNewTopologySpreadConstraintLike(index, buildTopologySpreadConstraint(index));
  }
  public PodSpecFluent.TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint() {
    if (topologySpreadConstraints.size() == 0) throw new RuntimeException("Can't edit first topologySpreadConstraints. The list is empty.");
    return setNewTopologySpreadConstraintLike(0, buildTopologySpreadConstraint(0));
  }
  public PodSpecFluent.TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint() {
    int index = topologySpreadConstraints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last topologySpreadConstraints. The list is empty.");
    return setNewTopologySpreadConstraintLike(index, buildTopologySpreadConstraint(index));
  }
  public PodSpecFluent.TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
    int index = -1;
    for (int i=0;i<topologySpreadConstraints.size();i++) { 
    if (predicate.test(topologySpreadConstraints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching topologySpreadConstraints. No match found.");
    return setNewTopologySpreadConstraintLike(index, buildTopologySpreadConstraint(index));
  }
  public A addToVolumes(Integer index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
  }
  public A setToVolumes(Integer index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    VolumeBuilder builder = new VolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
    if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
     return (A)this;
  }
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(Collection<Volume> items) {
    for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<VolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      VolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Volume> getVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public List<Volume> buildVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public Volume buildVolume(Integer index) {
    return this.volumes.get(index).build();
  }
  public Volume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public Volume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
    for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
    for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(List<Volume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
    if (volumes != null) {this.volumes = new ArrayList(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public PodSpecFluent.VolumesNested<A> addNewVolume() {
    return new PodSpecFluentImpl.VolumesNestedImpl();
  }
  public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
    return new PodSpecFluentImpl.VolumesNestedImpl(-1, item);
  }
  public PodSpecFluent.VolumesNested<A> setNewVolumeLike(Integer index,Volume item) {
    return new PodSpecFluentImpl.VolumesNestedImpl(index, item);
  }
  public PodSpecFluent.VolumesNested<A> editVolume(Integer index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public PodSpecFluent.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public PodSpecFluent.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public PodSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PodSpecFluentImpl that = (PodSpecFluentImpl) o;
    if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
    if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
    if (automountServiceAccountToken != null ? !automountServiceAccountToken.equals(that.automountServiceAccountToken) :that.automountServiceAccountToken != null) return false;
    if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
    if (dnsConfig != null ? !dnsConfig.equals(that.dnsConfig) :that.dnsConfig != null) return false;
    if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
    if (enableServiceLinks != null ? !enableServiceLinks.equals(that.enableServiceLinks) :that.enableServiceLinks != null) return false;
    if (ephemeralContainers != null ? !ephemeralContainers.equals(that.ephemeralContainers) :that.ephemeralContainers != null) return false;
    if (hostAliases != null ? !hostAliases.equals(that.hostAliases) :that.hostAliases != null) return false;
    if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
    if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
    if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
    if (hostUsers != null ? !hostUsers.equals(that.hostUsers) :that.hostUsers != null) return false;
    if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
    if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
    if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
    if (os != null ? !os.equals(that.os) :that.os != null) return false;
    if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
    if (preemptionPolicy != null ? !preemptionPolicy.equals(that.preemptionPolicy) :that.preemptionPolicy != null) return false;
    if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
    if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
    if (readinessGates != null ? !readinessGates.equals(that.readinessGates) :that.readinessGates != null) return false;
    if (resourceClaims != null ? !resourceClaims.equals(that.resourceClaims) :that.resourceClaims != null) return false;
    if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
    if (runtimeClassName != null ? !runtimeClassName.equals(that.runtimeClassName) :that.runtimeClassName != null) return false;
    if (schedulerName != null ? !schedulerName.equals(that.schedulerName) :that.schedulerName != null) return false;
    if (schedulingGates != null ? !schedulingGates.equals(that.schedulingGates) :that.schedulingGates != null) return false;
    if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
    if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
    if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
    if (setHostnameAsFQDN != null ? !setHostnameAsFQDN.equals(that.setHostnameAsFQDN) :that.setHostnameAsFQDN != null) return false;
    if (shareProcessNamespace != null ? !shareProcessNamespace.equals(that.shareProcessNamespace) :that.shareProcessNamespace != null) return false;
    if (subdomain != null ? !subdomain.equals(that.subdomain) :that.subdomain != null) return false;
    if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
    if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
    if (topologySpreadConstraints != null ? !topologySpreadConstraints.equals(that.topologySpreadConstraints) :that.topologySpreadConstraints != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(activeDeadlineSeconds,  affinity,  automountServiceAccountToken,  containers,  dnsConfig,  dnsPolicy,  enableServiceLinks,  ephemeralContainers,  hostAliases,  hostIPC,  hostNetwork,  hostPID,  hostUsers,  hostname,  imagePullSecrets,  initContainers,  nodeName,  nodeSelector,  os,  overhead,  preemptionPolicy,  priority,  priorityClassName,  readinessGates,  resourceClaims,  restartPolicy,  runtimeClassName,  schedulerName,  schedulingGates,  securityContext,  serviceAccount,  serviceAccountName,  setHostnameAsFQDN,  shareProcessNamespace,  subdomain,  terminationGracePeriodSeconds,  tolerations,  topologySpreadConstraints,  volumes,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activeDeadlineSeconds != null) { sb.append("activeDeadlineSeconds:"); sb.append(activeDeadlineSeconds + ","); }
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (automountServiceAccountToken != null) { sb.append("automountServiceAccountToken:"); sb.append(automountServiceAccountToken + ","); }
    if (containers != null && !containers.isEmpty()) { sb.append("containers:"); sb.append(containers + ","); }
    if (dnsConfig != null) { sb.append("dnsConfig:"); sb.append(dnsConfig + ","); }
    if (dnsPolicy != null) { sb.append("dnsPolicy:"); sb.append(dnsPolicy + ","); }
    if (enableServiceLinks != null) { sb.append("enableServiceLinks:"); sb.append(enableServiceLinks + ","); }
    if (ephemeralContainers != null && !ephemeralContainers.isEmpty()) { sb.append("ephemeralContainers:"); sb.append(ephemeralContainers + ","); }
    if (hostAliases != null && !hostAliases.isEmpty()) { sb.append("hostAliases:"); sb.append(hostAliases + ","); }
    if (hostIPC != null) { sb.append("hostIPC:"); sb.append(hostIPC + ","); }
    if (hostNetwork != null) { sb.append("hostNetwork:"); sb.append(hostNetwork + ","); }
    if (hostPID != null) { sb.append("hostPID:"); sb.append(hostPID + ","); }
    if (hostUsers != null) { sb.append("hostUsers:"); sb.append(hostUsers + ","); }
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (imagePullSecrets != null && !imagePullSecrets.isEmpty()) { sb.append("imagePullSecrets:"); sb.append(imagePullSecrets + ","); }
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (nodeName != null) { sb.append("nodeName:"); sb.append(nodeName + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (os != null) { sb.append("os:"); sb.append(os + ","); }
    if (overhead != null && !overhead.isEmpty()) { sb.append("overhead:"); sb.append(overhead + ","); }
    if (preemptionPolicy != null) { sb.append("preemptionPolicy:"); sb.append(preemptionPolicy + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (priorityClassName != null) { sb.append("priorityClassName:"); sb.append(priorityClassName + ","); }
    if (readinessGates != null && !readinessGates.isEmpty()) { sb.append("readinessGates:"); sb.append(readinessGates + ","); }
    if (resourceClaims != null && !resourceClaims.isEmpty()) { sb.append("resourceClaims:"); sb.append(resourceClaims + ","); }
    if (restartPolicy != null) { sb.append("restartPolicy:"); sb.append(restartPolicy + ","); }
    if (runtimeClassName != null) { sb.append("runtimeClassName:"); sb.append(runtimeClassName + ","); }
    if (schedulerName != null) { sb.append("schedulerName:"); sb.append(schedulerName + ","); }
    if (schedulingGates != null && !schedulingGates.isEmpty()) { sb.append("schedulingGates:"); sb.append(schedulingGates + ","); }
    if (securityContext != null) { sb.append("securityContext:"); sb.append(securityContext + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (setHostnameAsFQDN != null) { sb.append("setHostnameAsFQDN:"); sb.append(setHostnameAsFQDN + ","); }
    if (shareProcessNamespace != null) { sb.append("shareProcessNamespace:"); sb.append(shareProcessNamespace + ","); }
    if (subdomain != null) { sb.append("subdomain:"); sb.append(subdomain + ","); }
    if (terminationGracePeriodSeconds != null) { sb.append("terminationGracePeriodSeconds:"); sb.append(terminationGracePeriodSeconds + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty()) { sb.append("topologySpreadConstraints:"); sb.append(topologySpreadConstraints + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withAutomountServiceAccountToken() {
    return withAutomountServiceAccountToken(true);
  }
  public A withEnableServiceLinks() {
    return withEnableServiceLinks(true);
  }
  public A withHostIPC() {
    return withHostIPC(true);
  }
  public A withHostNetwork() {
    return withHostNetwork(true);
  }
  public A withHostPID() {
    return withHostPID(true);
  }
  public A withHostUsers() {
    return withHostUsers(true);
  }
  public A withSetHostnameAsFQDN() {
    return withSetHostnameAsFQDN(true);
  }
  public A withShareProcessNamespace() {
    return withShareProcessNamespace(true);
  }
  class AffinityNestedImpl<N> extends AffinityFluentImpl<PodSpecFluent.AffinityNested<N>> implements PodSpecFluent.AffinityNested<N>,Nested<N>{
    AffinityNestedImpl(Affinity item) {
      this.builder = new AffinityBuilder(this, item);
    }
    AffinityNestedImpl() {
      this.builder = new AffinityBuilder(this);
    }
    AffinityBuilder builder;
    public N and() {
      return (N) PodSpecFluentImpl.this.withAffinity(builder.build());
    }
    public N endAffinity() {
      return and();
    }
    
  }
  class ContainersNestedImpl<N> extends ContainerFluentImpl<PodSpecFluent.ContainersNested<N>> implements PodSpecFluent.ContainersNested<N>,Nested<N>{
    ContainersNestedImpl(Integer index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToContainers(index,builder.build());
    }
    public N endContainer() {
      return and();
    }
    
  }
  class DnsConfigNestedImpl<N> extends PodDNSConfigFluentImpl<PodSpecFluent.DnsConfigNested<N>> implements PodSpecFluent.DnsConfigNested<N>,Nested<N>{
    DnsConfigNestedImpl(PodDNSConfig item) {
      this.builder = new PodDNSConfigBuilder(this, item);
    }
    DnsConfigNestedImpl() {
      this.builder = new PodDNSConfigBuilder(this);
    }
    PodDNSConfigBuilder builder;
    public N and() {
      return (N) PodSpecFluentImpl.this.withDnsConfig(builder.build());
    }
    public N endDnsConfig() {
      return and();
    }
    
  }
  class EphemeralContainersNestedImpl<N> extends EphemeralContainerFluentImpl<PodSpecFluent.EphemeralContainersNested<N>> implements PodSpecFluent.EphemeralContainersNested<N>,Nested<N>{
    EphemeralContainersNestedImpl(Integer index,EphemeralContainer item) {
      this.index = index;
      this.builder = new EphemeralContainerBuilder(this, item);
    }
    EphemeralContainersNestedImpl() {
      this.index = -1;
      this.builder = new EphemeralContainerBuilder(this);
    }
    EphemeralContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToEphemeralContainers(index,builder.build());
    }
    public N endEphemeralContainer() {
      return and();
    }
    
  }
  class HostAliasesNestedImpl<N> extends HostAliasFluentImpl<PodSpecFluent.HostAliasesNested<N>> implements PodSpecFluent.HostAliasesNested<N>,Nested<N>{
    HostAliasesNestedImpl(Integer index,HostAlias item) {
      this.index = index;
      this.builder = new HostAliasBuilder(this, item);
    }
    HostAliasesNestedImpl() {
      this.index = -1;
      this.builder = new HostAliasBuilder(this);
    }
    HostAliasBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToHostAliases(index,builder.build());
    }
    public N endHostAlias() {
      return and();
    }
    
  }
  class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<PodSpecFluent.ImagePullSecretsNested<N>> implements PodSpecFluent.ImagePullSecretsNested<N>,Nested<N>{
    ImagePullSecretsNestedImpl(Integer index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ImagePullSecretsNestedImpl() {
      this.index = -1;
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToImagePullSecrets(index,builder.build());
    }
    public N endImagePullSecret() {
      return and();
    }
    
  }
  class InitContainersNestedImpl<N> extends ContainerFluentImpl<PodSpecFluent.InitContainersNested<N>> implements PodSpecFluent.InitContainersNested<N>,Nested<N>{
    InitContainersNestedImpl(Integer index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  class OsNestedImpl<N> extends PodOSFluentImpl<PodSpecFluent.OsNested<N>> implements PodSpecFluent.OsNested<N>,Nested<N>{
    OsNestedImpl(PodOS item) {
      this.builder = new PodOSBuilder(this, item);
    }
    OsNestedImpl() {
      this.builder = new PodOSBuilder(this);
    }
    PodOSBuilder builder;
    public N and() {
      return (N) PodSpecFluentImpl.this.withOs(builder.build());
    }
    public N endOs() {
      return and();
    }
    
  }
  class ReadinessGatesNestedImpl<N> extends PodReadinessGateFluentImpl<PodSpecFluent.ReadinessGatesNested<N>> implements PodSpecFluent.ReadinessGatesNested<N>,Nested<N>{
    ReadinessGatesNestedImpl(Integer index,PodReadinessGate item) {
      this.index = index;
      this.builder = new PodReadinessGateBuilder(this, item);
    }
    ReadinessGatesNestedImpl() {
      this.index = -1;
      this.builder = new PodReadinessGateBuilder(this);
    }
    PodReadinessGateBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToReadinessGates(index,builder.build());
    }
    public N endReadinessGate() {
      return and();
    }
    
  }
  class ResourceClaimsNestedImpl<N> extends PodResourceClaimFluentImpl<PodSpecFluent.ResourceClaimsNested<N>> implements PodSpecFluent.ResourceClaimsNested<N>,Nested<N>{
    ResourceClaimsNestedImpl(Integer index,PodResourceClaim item) {
      this.index = index;
      this.builder = new PodResourceClaimBuilder(this, item);
    }
    ResourceClaimsNestedImpl() {
      this.index = -1;
      this.builder = new PodResourceClaimBuilder(this);
    }
    PodResourceClaimBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToResourceClaims(index,builder.build());
    }
    public N endResourceClaim() {
      return and();
    }
    
  }
  class SchedulingGatesNestedImpl<N> extends PodSchedulingGateFluentImpl<PodSpecFluent.SchedulingGatesNested<N>> implements PodSpecFluent.SchedulingGatesNested<N>,Nested<N>{
    SchedulingGatesNestedImpl(Integer index,PodSchedulingGate item) {
      this.index = index;
      this.builder = new PodSchedulingGateBuilder(this, item);
    }
    SchedulingGatesNestedImpl() {
      this.index = -1;
      this.builder = new PodSchedulingGateBuilder(this);
    }
    PodSchedulingGateBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToSchedulingGates(index,builder.build());
    }
    public N endSchedulingGate() {
      return and();
    }
    
  }
  class SecurityContextNestedImpl<N> extends PodSecurityContextFluentImpl<PodSpecFluent.SecurityContextNested<N>> implements PodSpecFluent.SecurityContextNested<N>,Nested<N>{
    SecurityContextNestedImpl(PodSecurityContext item) {
      this.builder = new PodSecurityContextBuilder(this, item);
    }
    SecurityContextNestedImpl() {
      this.builder = new PodSecurityContextBuilder(this);
    }
    PodSecurityContextBuilder builder;
    public N and() {
      return (N) PodSpecFluentImpl.this.withSecurityContext(builder.build());
    }
    public N endSecurityContext() {
      return and();
    }
    
  }
  class TolerationsNestedImpl<N> extends TolerationFluentImpl<PodSpecFluent.TolerationsNested<N>> implements PodSpecFluent.TolerationsNested<N>,Nested<N>{
    TolerationsNestedImpl(Integer index,Toleration item) {
      this.index = index;
      this.builder = new TolerationBuilder(this, item);
    }
    TolerationsNestedImpl() {
      this.index = -1;
      this.builder = new TolerationBuilder(this);
    }
    TolerationBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToTolerations(index,builder.build());
    }
    public N endToleration() {
      return and();
    }
    
  }
  class TopologySpreadConstraintsNestedImpl<N> extends TopologySpreadConstraintFluentImpl<PodSpecFluent.TopologySpreadConstraintsNested<N>> implements PodSpecFluent.TopologySpreadConstraintsNested<N>,Nested<N>{
    TopologySpreadConstraintsNestedImpl(Integer index,TopologySpreadConstraint item) {
      this.index = index;
      this.builder = new TopologySpreadConstraintBuilder(this, item);
    }
    TopologySpreadConstraintsNestedImpl() {
      this.index = -1;
      this.builder = new TopologySpreadConstraintBuilder(this);
    }
    TopologySpreadConstraintBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToTopologySpreadConstraints(index,builder.build());
    }
    public N endTopologySpreadConstraint() {
      return and();
    }
    
  }
  class VolumesNestedImpl<N> extends VolumeFluentImpl<PodSpecFluent.VolumesNested<N>> implements PodSpecFluent.VolumesNested<N>,Nested<N>{
    VolumesNestedImpl(Integer index,Volume item) {
      this.index = index;
      this.builder = new VolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new VolumeBuilder(this);
    }
    VolumeBuilder builder;
    Integer index;
    public N and() {
      return (N) PodSpecFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  
}