package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ResourceQuotaListFluent<A extends ResourceQuotaListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,ResourceQuota item);
  public A setToItems(Integer index,ResourceQuota item);
  public A addToItems(io.fabric8.kubernetes.api.model.ResourceQuota... items);
  public A addAllToItems(Collection<ResourceQuota> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.ResourceQuota... items);
  public A removeAllFromItems(Collection<ResourceQuota> items);
  public A removeMatchingFromItems(Predicate<ResourceQuotaBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ResourceQuota> getItems();
  public List<ResourceQuota> buildItems();
  public ResourceQuota buildItem(Integer index);
  public ResourceQuota buildFirstItem();
  public ResourceQuota buildLastItem();
  public ResourceQuota buildMatchingItem(Predicate<ResourceQuotaBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ResourceQuotaBuilder> predicate);
  public A withItems(List<ResourceQuota> items);
  public A withItems(io.fabric8.kubernetes.api.model.ResourceQuota... items);
  public Boolean hasItems();
  public ResourceQuotaListFluent.ItemsNested<A> addNewItem();
  public ResourceQuotaListFluent.ItemsNested<A> addNewItemLike(ResourceQuota item);
  public ResourceQuotaListFluent.ItemsNested<A> setNewItemLike(Integer index,ResourceQuota item);
  public ResourceQuotaListFluent.ItemsNested<A> editItem(Integer index);
  public ResourceQuotaListFluent.ItemsNested<A> editFirstItem();
  public ResourceQuotaListFluent.ItemsNested<A> editLastItem();
  public ResourceQuotaListFluent.ItemsNested<A> editMatchingItem(Predicate<ResourceQuotaBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public ResourceQuotaListFluent.MetadataNested<A> withNewMetadata();
  public ResourceQuotaListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public ResourceQuotaListFluent.MetadataNested<A> editMetadata();
  public ResourceQuotaListFluent.MetadataNested<A> editOrNewMetadata();
  public ResourceQuotaListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ResourceQuotaFluent<ResourceQuotaListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ResourceQuotaListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}