package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceListFluent<A extends ServiceListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(Integer index,Service item);
  public A setToItems(Integer index,Service item);
  public A addToItems(io.fabric8.kubernetes.api.model.Service... items);
  public A addAllToItems(Collection<Service> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.Service... items);
  public A removeAllFromItems(Collection<Service> items);
  public A removeMatchingFromItems(Predicate<ServiceBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Service> getItems();
  public List<Service> buildItems();
  public Service buildItem(Integer index);
  public Service buildFirstItem();
  public Service buildLastItem();
  public Service buildMatchingItem(Predicate<ServiceBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ServiceBuilder> predicate);
  public A withItems(List<Service> items);
  public A withItems(io.fabric8.kubernetes.api.model.Service... items);
  public Boolean hasItems();
  public ServiceListFluent.ItemsNested<A> addNewItem();
  public ServiceListFluent.ItemsNested<A> addNewItemLike(Service item);
  public ServiceListFluent.ItemsNested<A> setNewItemLike(Integer index,Service item);
  public ServiceListFluent.ItemsNested<A> editItem(Integer index);
  public ServiceListFluent.ItemsNested<A> editFirstItem();
  public ServiceListFluent.ItemsNested<A> editLastItem();
  public ServiceListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public ServiceListFluent.MetadataNested<A> withNewMetadata();
  public ServiceListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public ServiceListFluent.MetadataNested<A> editMetadata();
  public ServiceListFluent.MetadataNested<A> editOrNewMetadata();
  public ServiceListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ServiceFluent<ServiceListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ServiceListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}