package io.fabric8.kubernetes.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TCPSocketActionFluentImpl<A extends TCPSocketActionFluent<A>> extends BaseFluent<A> implements TCPSocketActionFluent<A>{
  public TCPSocketActionFluentImpl() {
  }
  public TCPSocketActionFluentImpl(TCPSocketAction instance) {
    this.withHost(instance.getHost()); 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String host;
  private IntOrStringBuilder port;
  private Map<String,Object> additionalProperties;
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public IntOrString buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(IntOrString port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(Object value) {
    return (A)withPort(new IntOrString(value));
  }
  public TCPSocketActionFluent.PortNested<A> withNewPort() {
    return new TCPSocketActionFluentImpl.PortNestedImpl();
  }
  public TCPSocketActionFluent.PortNested<A> withNewPortLike(IntOrString item) {
    return new TCPSocketActionFluentImpl.PortNestedImpl(item);
  }
  public TCPSocketActionFluent.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public TCPSocketActionFluent.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new IntOrStringBuilder().build());
  }
  public TCPSocketActionFluent.PortNested<A> editOrNewPortLike(IntOrString item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TCPSocketActionFluentImpl that = (TCPSocketActionFluentImpl) o;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  port,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PortNestedImpl<N> extends IntOrStringFluentImpl<TCPSocketActionFluent.PortNested<N>> implements TCPSocketActionFluent.PortNested<N>,Nested<N>{
    PortNestedImpl(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new IntOrStringBuilder(this);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) TCPSocketActionFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}