package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeMountBuilder extends VolumeMountFluentImpl<VolumeMountBuilder> implements VisitableBuilder<VolumeMount,VolumeMountBuilder>{
  public VolumeMountBuilder() {
    this(false);
  }
  public VolumeMountBuilder(Boolean validationEnabled) {
    this(new VolumeMount(), validationEnabled);
  }
  public VolumeMountBuilder(VolumeMountFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeMountBuilder(VolumeMountFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeMount(), validationEnabled);
  }
  public VolumeMountBuilder(VolumeMountFluent<?> fluent,VolumeMount instance) {
    this(fluent, instance, false);
  }
  public VolumeMountBuilder(VolumeMountFluent<?> fluent,VolumeMount instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMountPath(instance.getMountPath()); 
    fluent.withMountPropagation(instance.getMountPropagation()); 
    fluent.withName(instance.getName()); 
    fluent.withReadOnly(instance.getReadOnly()); 
    fluent.withSubPath(instance.getSubPath()); 
    fluent.withSubPathExpr(instance.getSubPathExpr()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public VolumeMountBuilder(VolumeMount instance) {
    this(instance,false);
  }
  public VolumeMountBuilder(VolumeMount instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMountPath(instance.getMountPath()); 
    this.withMountPropagation(instance.getMountPropagation()); 
    this.withName(instance.getName()); 
    this.withReadOnly(instance.getReadOnly()); 
    this.withSubPath(instance.getSubPath()); 
    this.withSubPathExpr(instance.getSubPathExpr()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  VolumeMountFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeMount build() {
    VolumeMount buildable = new VolumeMount(fluent.getMountPath(),fluent.getMountPropagation(),fluent.getName(),fluent.getReadOnly(),fluent.getSubPath(),fluent.getSubPathExpr());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}