package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServiceBuilder extends APIServiceFluentImpl<APIServiceBuilder> implements VisitableBuilder<APIService,APIServiceBuilder>{
  public APIServiceBuilder() {
    this(false);
  }
  public APIServiceBuilder(Boolean validationEnabled) {
    this(new APIService(), validationEnabled);
  }
  public APIServiceBuilder(APIServiceFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceBuilder(APIServiceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIService(), validationEnabled);
  }
  public APIServiceBuilder(APIServiceFluent<?> fluent,APIService instance) {
    this(fluent, instance, false);
  }
  public APIServiceBuilder(APIServiceFluent<?> fluent,APIService instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIServiceBuilder(APIService instance) {
    this(instance,false);
  }
  public APIServiceBuilder(APIService instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIServiceFluent<?> fluent;
  Boolean validationEnabled;
  public APIService build() {
    APIService buildable = new APIService(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}