package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSElasticBlockStoreVolumeSourceBuilder extends AWSElasticBlockStoreVolumeSourceFluentImpl<AWSElasticBlockStoreVolumeSourceBuilder> implements VisitableBuilder<AWSElasticBlockStoreVolumeSource,AWSElasticBlockStoreVolumeSourceBuilder>{
  public AWSElasticBlockStoreVolumeSourceBuilder() {
    this(false);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(Boolean validationEnabled) {
    this(new AWSElasticBlockStoreVolumeSource(), validationEnabled);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSElasticBlockStoreVolumeSource(), validationEnabled);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent,AWSElasticBlockStoreVolumeSource instance) {
    this(fluent, instance, false);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSourceFluent<?> fluent,AWSElasticBlockStoreVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withPartition(instance.getPartition());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withVolumeID(instance.getVolumeID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSource instance) {
    this(instance,false);
  }
  public AWSElasticBlockStoreVolumeSourceBuilder(AWSElasticBlockStoreVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withPartition(instance.getPartition());
      this.withReadOnly(instance.getReadOnly());
      this.withVolumeID(instance.getVolumeID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AWSElasticBlockStoreVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public AWSElasticBlockStoreVolumeSource build() {
    AWSElasticBlockStoreVolumeSource buildable = new AWSElasticBlockStoreVolumeSource(fluent.getFsType(),fluent.getPartition(),fluent.getReadOnly(),fluent.getVolumeID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}