package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClientIPConfigBuilder extends ClientIPConfigFluentImpl<ClientIPConfigBuilder> implements VisitableBuilder<ClientIPConfig,ClientIPConfigBuilder>{
  public ClientIPConfigBuilder() {
    this(false);
  }
  public ClientIPConfigBuilder(Boolean validationEnabled) {
    this(new ClientIPConfig(), validationEnabled);
  }
  public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClientIPConfig(), validationEnabled);
  }
  public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent,ClientIPConfig instance) {
    this(fluent, instance, false);
  }
  public ClientIPConfigBuilder(ClientIPConfigFluent<?> fluent,ClientIPConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClientIPConfigBuilder(ClientIPConfig instance) {
    this(instance,false);
  }
  public ClientIPConfigBuilder(ClientIPConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClientIPConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ClientIPConfig build() {
    ClientIPConfig buildable = new ClientIPConfig(fluent.getTimeoutSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}