package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContextBuilder extends ContextFluentImpl<ContextBuilder> implements VisitableBuilder<Context,ContextBuilder>{
  public ContextBuilder() {
    this(false);
  }
  public ContextBuilder(Boolean validationEnabled) {
    this(new Context(), validationEnabled);
  }
  public ContextBuilder(ContextFluent<?> fluent) {
    this(fluent, false);
  }
  public ContextBuilder(ContextFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Context(), validationEnabled);
  }
  public ContextBuilder(ContextFluent<?> fluent,Context instance) {
    this(fluent, instance, false);
  }
  public ContextBuilder(ContextFluent<?> fluent,Context instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCluster(instance.getCluster());
      fluent.withExtensions(instance.getExtensions());
      fluent.withNamespace(instance.getNamespace());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContextBuilder(Context instance) {
    this(instance,false);
  }
  public ContextBuilder(Context instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCluster(instance.getCluster());
      this.withExtensions(instance.getExtensions());
      this.withNamespace(instance.getNamespace());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContextFluent<?> fluent;
  Boolean validationEnabled;
  public Context build() {
    Context buildable = new Context(fluent.getCluster(),fluent.getExtensions(),fluent.getNamespace(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}