package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeleteOptionsBuilder extends DeleteOptionsFluentImpl<DeleteOptionsBuilder> implements VisitableBuilder<DeleteOptions,DeleteOptionsBuilder>{
  public DeleteOptionsBuilder() {
    this(false);
  }
  public DeleteOptionsBuilder(Boolean validationEnabled) {
    this(new DeleteOptions(), validationEnabled);
  }
  public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeleteOptions(), validationEnabled);
  }
  public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent,DeleteOptions instance) {
    this(fluent, instance, false);
  }
  public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent,DeleteOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDryRun(instance.getDryRun());
      fluent.withGracePeriodSeconds(instance.getGracePeriodSeconds());
      fluent.withKind(instance.getKind());
      fluent.withOrphanDependents(instance.getOrphanDependents());
      fluent.withPreconditions(instance.getPreconditions());
      fluent.withPropagationPolicy(instance.getPropagationPolicy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeleteOptionsBuilder(DeleteOptions instance) {
    this(instance,false);
  }
  public DeleteOptionsBuilder(DeleteOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withDryRun(instance.getDryRun());
      this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
      this.withKind(instance.getKind());
      this.withOrphanDependents(instance.getOrphanDependents());
      this.withPreconditions(instance.getPreconditions());
      this.withPropagationPolicy(instance.getPropagationPolicy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeleteOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public DeleteOptions build() {
    DeleteOptions buildable = new DeleteOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getGracePeriodSeconds(),fluent.getKind(),fluent.getOrphanDependents(),fluent.getPreconditions(),fluent.getPropagationPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}