package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointsListBuilder extends EndpointsListFluentImpl<EndpointsListBuilder> implements VisitableBuilder<EndpointsList,EndpointsListBuilder>{
  public EndpointsListBuilder() {
    this(false);
  }
  public EndpointsListBuilder(Boolean validationEnabled) {
    this(new EndpointsList(), validationEnabled);
  }
  public EndpointsListBuilder(EndpointsListFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointsListBuilder(EndpointsListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EndpointsList(), validationEnabled);
  }
  public EndpointsListBuilder(EndpointsListFluent<?> fluent,EndpointsList instance) {
    this(fluent, instance, false);
  }
  public EndpointsListBuilder(EndpointsListFluent<?> fluent,EndpointsList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EndpointsListBuilder(EndpointsList instance) {
    this(instance,false);
  }
  public EndpointsListBuilder(EndpointsList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EndpointsListFluent<?> fluent;
  Boolean validationEnabled;
  public EndpointsList build() {
    EndpointsList buildable = new EndpointsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}