package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface FlexVolumeSourceFluent<A extends FlexVolumeSourceFluent<A>> extends Fluent<A>{
  public String getDriver();
  public A withDriver(String driver);
  public Boolean hasDriver();
  public String getFsType();
  public A withFsType(String fsType);
  public Boolean hasFsType();
  public A addToOptions(String key,String value);
  public A addToOptions(Map<String,String> map);
  public A removeFromOptions(String key);
  public A removeFromOptions(Map<String,String> map);
  public Map<String,String> getOptions();
  public <K,V>A withOptions(Map<String,String> options);
  public Boolean hasOptions();
  public Boolean getReadOnly();
  public A withReadOnly(Boolean readOnly);
  public Boolean hasReadOnly();
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getSecretRef();
  public LocalObjectReference buildSecretRef();
  public A withSecretRef(LocalObjectReference secretRef);
  public Boolean hasSecretRef();
  public A withNewSecretRef(String name);
  public FlexVolumeSourceFluent.SecretRefNested<A> withNewSecretRef();
  public FlexVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item);
  public FlexVolumeSourceFluent.SecretRefNested<A> editSecretRef();
  public FlexVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef();
  public FlexVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withReadOnly();
  public interface SecretRefNested<N> extends Nested<N>,LocalObjectReferenceFluent<FlexVolumeSourceFluent.SecretRefNested<N>>{
    public N and();
    public N endSecretRef();
    
  }
  
}