package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Long;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KubernetesListFluentImpl<A extends KubernetesListFluent<A>> extends BaseFluent<A> implements KubernetesListFluent<A>{
  public KubernetesListFluentImpl() {
  }
  public KubernetesListFluentImpl(KubernetesList instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
  }
  private String apiVersion;
  private ArrayList<VisitableBuilder<? extends HasMetadata,?>> items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();
  private String kind;
  private ListMetaBuilder metadata;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    _visitables.get("items").add(builder);this.items.add(builder); return (A)this;
  }
  public A addToItems(int index,VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A addToItems(int index,HasMetadata item) {
    if (item instanceof LimitRange){addToLimitRangeItems(index, (LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems(index, (APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems(index, (Namespace)item);}
 else if (item instanceof Service){addToServiceItems(index, (Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems(index, (ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems(index, (PodTemplate)item);}
 else if (item instanceof Event){addToEventItems(index, (Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems(index, (PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems(index, (PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceItems(index, (GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){addToEndpointsItems(index, (Endpoints)item);}
 else if (item instanceof Pod){addToPodItems(index, (Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems(index, (ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems(index, (ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems(index, (Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems(index, (ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems(index, (Secret)item);}
 else if (item instanceof Node){addToNodeItems(index, (Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems(index, (ServiceAccount)item);}

    else { VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    } return (A)this;
  }
  public A setToItems(int index,HasMetadata item) {
    if (item instanceof LimitRange){setToLimitRangeItems(index, (LimitRange)item);}
 else if (item instanceof APIService){setToAPIServiceItems(index, (APIService)item);}
 else if (item instanceof Namespace){setToNamespaceItems(index, (Namespace)item);}
 else if (item instanceof Service){setToServiceItems(index, (Service)item);}
 else if (item instanceof ReplicationController){setToReplicationControllerItems(index, (ReplicationController)item);}
 else if (item instanceof PodTemplate){setToPodTemplateItems(index, (PodTemplate)item);}
 else if (item instanceof Event){setToEventItems(index, (Event)item);}
 else if (item instanceof PersistentVolume){setToPersistentVolumeItems(index, (PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){setToPersistentVolumeClaimItems(index, (PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){setToGenericKubernetesResourceItems(index, (GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){setToEndpointsItems(index, (Endpoints)item);}
 else if (item instanceof Pod){setToPodItems(index, (Pod)item);}
 else if (item instanceof ConfigMap){setToConfigMapItems(index, (ConfigMap)item);}
 else if (item instanceof ComponentStatus){setToComponentStatusItems(index, (ComponentStatus)item);}
 else if (item instanceof Binding){setToBindingItems(index, (Binding)item);}
 else if (item instanceof ResourceQuota){setToResourceQuotaItems(index, (ResourceQuota)item);}
 else if (item instanceof Secret){setToSecretItems(index, (Secret)item);}
 else if (item instanceof Node){setToNodeItems(index, (Node)item);}
 else if (item instanceof ServiceAccount){setToServiceAccountItems(index, (ServiceAccount)item);}

    else { VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    } return (A)this;
  }
  public A addToItems(io.fabric8.kubernetes.api.model.HasMetadata... items) {
     if (items != null && items.length > 0 && this.items== null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { 
    if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceItems((GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").add(builder);this.items.add(builder); }
    } return (A)this;
  }
  public A addAllToItems(Collection<HasMetadata> items) {
     if (items != null && items.size() > 0 && this.items== null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (HasMetadata item : items) { 
    if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){addToAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){addToGenericKubernetesResourceItems((GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof ConfigMap){addToConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").add(builder);this.items.add(builder); }
    } return (A)this;
  }
  public A removeFromItems(VisitableBuilder<? extends HasMetadata,?> builder) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    _visitables.get("items").remove(builder);this.items.remove(builder); return (A)this;
  }
  public A removeFromItems(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){removeFromAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){removeFromGenericKubernetesResourceItems((GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof ConfigMap){removeFromConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").remove(builder);this.items.remove(builder); }
    } return (A)this;
  }
  public A removeAllFromItems(Collection<HasMetadata> items) {
    for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof APIService){removeFromAPIServiceItems((APIService)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof GenericKubernetesResource){removeFromGenericKubernetesResourceItems((GenericKubernetesResource)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof ConfigMap){removeFromConfigMapItems((ConfigMap)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}

    else {  VisitableBuilder<? extends HasMetadata,?> builder = builderOf(item); _visitables.get("items").remove(builder);this.items.remove(builder); }
    } return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<HasMetadata> getItems() {
    return build(items);
  }
  public List<HasMetadata> buildItems() {
    return build(items);
  }
  public HasMetadata buildItem(int index) {
    return this.items.get(index).build();
  }
  public HasMetadata buildFirstItem() {
    return this.items.get(0).build();
  }
  public HasMetadata buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public HasMetadata buildMatchingItem(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    for (VisitableBuilder<? extends HasMetadata,?> item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    for (VisitableBuilder<? extends HasMetadata,?> item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<HasMetadata> items) {
    if (items != null) {this.items = new ArrayList(); for (HasMetadata item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.kubernetes.api.model.HasMetadata... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (HasMetadata item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public A addToLimitRangeItems(int index,LimitRange item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    LimitRangeBuilder builder = new LimitRangeBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToLimitRangeItems(int index,LimitRange item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    LimitRangeBuilder builder = new LimitRangeBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToLimitRangeItems(Collection<LimitRange> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromLimitRangeItems(io.fabric8.kubernetes.api.model.LimitRange... items) {
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromLimitRangeItems(Collection<LimitRange> items) {
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLimitRangeItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.LimitRangeItemsNested<A> addNewLimitRangeItem() {
    return new KubernetesListFluentImpl.LimitRangeItemsNestedImpl();
  }
  public KubernetesListFluentImpl.LimitRangeItemsNested<A> addNewLimitRangeItemLike(LimitRange item) {
    return new KubernetesListFluentImpl.LimitRangeItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.LimitRangeItemsNested<A> setNewLimitRangeItemLike(int index,LimitRange item) {
    return new KubernetesListFluentImpl.LimitRangeItemsNestedImpl(index, item);
  }
  public A addToAPIServiceItems(int index,APIService item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    APIServiceBuilder builder = new APIServiceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToAPIServiceItems(int index,APIService item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    APIServiceBuilder builder = new APIServiceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToAPIServiceItems(Collection<APIService> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromAPIServiceItems(io.fabric8.kubernetes.api.model.APIService... items) {
    for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromAPIServiceItems(Collection<APIService> items) {
    for (APIService item : items) {APIServiceBuilder builder = new APIServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAPIServiceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.APIServiceItemsNested<A> addNewAPIServiceItem() {
    return new KubernetesListFluentImpl.APIServiceItemsNestedImpl();
  }
  public KubernetesListFluentImpl.APIServiceItemsNested<A> addNewAPIServiceItemLike(APIService item) {
    return new KubernetesListFluentImpl.APIServiceItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.APIServiceItemsNested<A> setNewAPIServiceItemLike(int index,APIService item) {
    return new KubernetesListFluentImpl.APIServiceItemsNestedImpl(index, item);
  }
  public A addToNamespaceItems(int index,Namespace item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NamespaceBuilder builder = new NamespaceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToNamespaceItems(int index,Namespace item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NamespaceBuilder builder = new NamespaceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToNamespaceItems(Collection<Namespace> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromNamespaceItems(io.fabric8.kubernetes.api.model.Namespace... items) {
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromNamespaceItems(Collection<Namespace> items) {
    for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNamespaceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.NamespaceItemsNested<A> addNewNamespaceItem() {
    return new KubernetesListFluentImpl.NamespaceItemsNestedImpl();
  }
  public KubernetesListFluentImpl.NamespaceItemsNested<A> addNewNamespaceItemLike(Namespace item) {
    return new KubernetesListFluentImpl.NamespaceItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.NamespaceItemsNested<A> setNewNamespaceItemLike(int index,Namespace item) {
    return new KubernetesListFluentImpl.NamespaceItemsNestedImpl(index, item);
  }
  public A addToServiceItems(int index,Service item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ServiceBuilder builder = new ServiceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToServiceItems(int index,Service item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ServiceBuilder builder = new ServiceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToServiceItems(io.fabric8.kubernetes.api.model.Service... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToServiceItems(Collection<Service> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromServiceItems(io.fabric8.kubernetes.api.model.Service... items) {
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceItems(Collection<Service> items) {
    for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.ServiceItemsNested<A> addNewServiceItem() {
    return new KubernetesListFluentImpl.ServiceItemsNestedImpl();
  }
  public KubernetesListFluentImpl.ServiceItemsNested<A> addNewServiceItemLike(Service item) {
    return new KubernetesListFluentImpl.ServiceItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.ServiceItemsNested<A> setNewServiceItemLike(int index,Service item) {
    return new KubernetesListFluentImpl.ServiceItemsNestedImpl(index, item);
  }
  public A addToReplicationControllerItems(int index,ReplicationController item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToReplicationControllerItems(int index,ReplicationController item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToReplicationControllerItems(Collection<ReplicationController> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromReplicationControllerItems(io.fabric8.kubernetes.api.model.ReplicationController... items) {
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromReplicationControllerItems(Collection<ReplicationController> items) {
    for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromReplicationControllerItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.ReplicationControllerItemsNested<A> addNewReplicationControllerItem() {
    return new KubernetesListFluentImpl.ReplicationControllerItemsNestedImpl();
  }
  public KubernetesListFluentImpl.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(ReplicationController item) {
    return new KubernetesListFluentImpl.ReplicationControllerItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.ReplicationControllerItemsNested<A> setNewReplicationControllerItemLike(int index,ReplicationController item) {
    return new KubernetesListFluentImpl.ReplicationControllerItemsNestedImpl(index, item);
  }
  public A addToPodTemplateItems(int index,PodTemplate item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PodTemplateBuilder builder = new PodTemplateBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToPodTemplateItems(int index,PodTemplate item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PodTemplateBuilder builder = new PodTemplateBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPodTemplateItems(Collection<PodTemplate> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPodTemplateItems(io.fabric8.kubernetes.api.model.PodTemplate... items) {
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodTemplateItems(Collection<PodTemplate> items) {
    for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodTemplateItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.PodTemplateItemsNested<A> addNewPodTemplateItem() {
    return new KubernetesListFluentImpl.PodTemplateItemsNestedImpl();
  }
  public KubernetesListFluentImpl.PodTemplateItemsNested<A> addNewPodTemplateItemLike(PodTemplate item) {
    return new KubernetesListFluentImpl.PodTemplateItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.PodTemplateItemsNested<A> setNewPodTemplateItemLike(int index,PodTemplate item) {
    return new KubernetesListFluentImpl.PodTemplateItemsNestedImpl(index, item);
  }
  public A addToEventItems(int index,Event item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EventBuilder builder = new EventBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToEventItems(int index,Event item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EventBuilder builder = new EventBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToEventItems(io.fabric8.kubernetes.api.model.Event... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToEventItems(Collection<Event> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromEventItems(io.fabric8.kubernetes.api.model.Event... items) {
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromEventItems(Collection<Event> items) {
    for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEventItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.EventItemsNested<A> addNewEventItem() {
    return new KubernetesListFluentImpl.EventItemsNestedImpl();
  }
  public KubernetesListFluentImpl.EventItemsNested<A> addNewEventItemLike(Event item) {
    return new KubernetesListFluentImpl.EventItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.EventItemsNested<A> setNewEventItemLike(int index,Event item) {
    return new KubernetesListFluentImpl.EventItemsNestedImpl(index, item);
  }
  public A addToPersistentVolumeItems(int index,PersistentVolume item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToPersistentVolumeItems(int index,PersistentVolume item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPersistentVolumeItems(Collection<PersistentVolume> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPersistentVolumeItems(io.fabric8.kubernetes.api.model.PersistentVolume... items) {
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPersistentVolumeItems(Collection<PersistentVolume> items) {
    for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPersistentVolumeItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem() {
    return new KubernetesListFluentImpl.PersistentVolumeItemsNestedImpl();
  }
  public KubernetesListFluentImpl.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(PersistentVolume item) {
    return new KubernetesListFluentImpl.PersistentVolumeItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.PersistentVolumeItemsNested<A> setNewPersistentVolumeItemLike(int index,PersistentVolume item) {
    return new KubernetesListFluentImpl.PersistentVolumeItemsNestedImpl(index, item);
  }
  public A addToPersistentVolumeClaimItems(int index,PersistentVolumeClaim item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToPersistentVolumeClaimItems(int index,PersistentVolumeClaim item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPersistentVolumeClaimItems(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPersistentVolumeClaimItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem() {
    return new KubernetesListFluentImpl.PersistentVolumeClaimItemsNestedImpl();
  }
  public KubernetesListFluentImpl.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(PersistentVolumeClaim item) {
    return new KubernetesListFluentImpl.PersistentVolumeClaimItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.PersistentVolumeClaimItemsNested<A> setNewPersistentVolumeClaimItemLike(int index,PersistentVolumeClaim item) {
    return new KubernetesListFluentImpl.PersistentVolumeClaimItemsNestedImpl(index, item);
  }
  public A addToGenericKubernetesResourceItems(int index,GenericKubernetesResource item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToGenericKubernetesResourceItems(int index,GenericKubernetesResource item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToGenericKubernetesResourceItems(Collection<GenericKubernetesResource> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromGenericKubernetesResourceItems(io.fabric8.kubernetes.api.model.GenericKubernetesResource... items) {
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromGenericKubernetesResourceItems(Collection<GenericKubernetesResource> items) {
    for (GenericKubernetesResource item : items) {GenericKubernetesResourceBuilder builder = new GenericKubernetesResourceBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromGenericKubernetesResourceItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItem() {
    return new KubernetesListFluentImpl.GenericKubernetesResourceItemsNestedImpl();
  }
  public KubernetesListFluentImpl.GenericKubernetesResourceItemsNested<A> addNewGenericKubernetesResourceItemLike(GenericKubernetesResource item) {
    return new KubernetesListFluentImpl.GenericKubernetesResourceItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.GenericKubernetesResourceItemsNested<A> setNewGenericKubernetesResourceItemLike(int index,GenericKubernetesResource item) {
    return new KubernetesListFluentImpl.GenericKubernetesResourceItemsNestedImpl(index, item);
  }
  public A addToEndpointsItems(int index,Endpoints item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EndpointsBuilder builder = new EndpointsBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToEndpointsItems(int index,Endpoints item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    EndpointsBuilder builder = new EndpointsBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToEndpointsItems(Collection<Endpoints> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromEndpointsItems(io.fabric8.kubernetes.api.model.Endpoints... items) {
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpointsItems(Collection<Endpoints> items) {
    for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpointsItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.EndpointsItemsNested<A> addNewEndpointsItem() {
    return new KubernetesListFluentImpl.EndpointsItemsNestedImpl();
  }
  public KubernetesListFluentImpl.EndpointsItemsNested<A> addNewEndpointsItemLike(Endpoints item) {
    return new KubernetesListFluentImpl.EndpointsItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.EndpointsItemsNested<A> setNewEndpointsItemLike(int index,Endpoints item) {
    return new KubernetesListFluentImpl.EndpointsItemsNestedImpl(index, item);
  }
  public A addToPodItems(int index,Pod item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PodBuilder builder = new PodBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToPodItems(int index,Pod item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    PodBuilder builder = new PodBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToPodItems(io.fabric8.kubernetes.api.model.Pod... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToPodItems(Collection<Pod> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromPodItems(io.fabric8.kubernetes.api.model.Pod... items) {
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromPodItems(Collection<Pod> items) {
    for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPodItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.PodItemsNested<A> addNewPodItem() {
    return new KubernetesListFluentImpl.PodItemsNestedImpl();
  }
  public KubernetesListFluentImpl.PodItemsNested<A> addNewPodItemLike(Pod item) {
    return new KubernetesListFluentImpl.PodItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.PodItemsNested<A> setNewPodItemLike(int index,Pod item) {
    return new KubernetesListFluentImpl.PodItemsNestedImpl(index, item);
  }
  public A addToConfigMapItems(int index,ConfigMap item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ConfigMapBuilder builder = new ConfigMapBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToConfigMapItems(int index,ConfigMap item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ConfigMapBuilder builder = new ConfigMapBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToConfigMapItems(Collection<ConfigMap> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromConfigMapItems(io.fabric8.kubernetes.api.model.ConfigMap... items) {
    for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromConfigMapItems(Collection<ConfigMap> items) {
    for (ConfigMap item : items) {ConfigMapBuilder builder = new ConfigMapBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConfigMapItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.ConfigMapItemsNested<A> addNewConfigMapItem() {
    return new KubernetesListFluentImpl.ConfigMapItemsNestedImpl();
  }
  public KubernetesListFluentImpl.ConfigMapItemsNested<A> addNewConfigMapItemLike(ConfigMap item) {
    return new KubernetesListFluentImpl.ConfigMapItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.ConfigMapItemsNested<A> setNewConfigMapItemLike(int index,ConfigMap item) {
    return new KubernetesListFluentImpl.ConfigMapItemsNestedImpl(index, item);
  }
  public A addToComponentStatusItems(int index,ComponentStatus item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ComponentStatusBuilder builder = new ComponentStatusBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToComponentStatusItems(int index,ComponentStatus item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ComponentStatusBuilder builder = new ComponentStatusBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToComponentStatusItems(Collection<ComponentStatus> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromComponentStatusItems(io.fabric8.kubernetes.api.model.ComponentStatus... items) {
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromComponentStatusItems(Collection<ComponentStatus> items) {
    for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromComponentStatusItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.ComponentStatusItemsNested<A> addNewComponentStatusItem() {
    return new KubernetesListFluentImpl.ComponentStatusItemsNestedImpl();
  }
  public KubernetesListFluentImpl.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(ComponentStatus item) {
    return new KubernetesListFluentImpl.ComponentStatusItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.ComponentStatusItemsNested<A> setNewComponentStatusItemLike(int index,ComponentStatus item) {
    return new KubernetesListFluentImpl.ComponentStatusItemsNestedImpl(index, item);
  }
  public A addToBindingItems(int index,Binding item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BindingBuilder builder = new BindingBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToBindingItems(int index,Binding item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    BindingBuilder builder = new BindingBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToBindingItems(io.fabric8.kubernetes.api.model.Binding... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToBindingItems(Collection<Binding> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromBindingItems(io.fabric8.kubernetes.api.model.Binding... items) {
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromBindingItems(Collection<Binding> items) {
    for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBindingItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.BindingItemsNested<A> addNewBindingItem() {
    return new KubernetesListFluentImpl.BindingItemsNestedImpl();
  }
  public KubernetesListFluentImpl.BindingItemsNested<A> addNewBindingItemLike(Binding item) {
    return new KubernetesListFluentImpl.BindingItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.BindingItemsNested<A> setNewBindingItemLike(int index,Binding item) {
    return new KubernetesListFluentImpl.BindingItemsNestedImpl(index, item);
  }
  public A addToResourceQuotaItems(int index,ResourceQuota item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToResourceQuotaItems(int index,ResourceQuota item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToResourceQuotaItems(Collection<ResourceQuota> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromResourceQuotaItems(io.fabric8.kubernetes.api.model.ResourceQuota... items) {
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceQuotaItems(Collection<ResourceQuota> items) {
    for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceQuotaItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.ResourceQuotaItemsNested<A> addNewResourceQuotaItem() {
    return new KubernetesListFluentImpl.ResourceQuotaItemsNestedImpl();
  }
  public KubernetesListFluentImpl.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(ResourceQuota item) {
    return new KubernetesListFluentImpl.ResourceQuotaItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.ResourceQuotaItemsNested<A> setNewResourceQuotaItemLike(int index,ResourceQuota item) {
    return new KubernetesListFluentImpl.ResourceQuotaItemsNestedImpl(index, item);
  }
  public A addToSecretItems(int index,Secret item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    SecretBuilder builder = new SecretBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToSecretItems(int index,Secret item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    SecretBuilder builder = new SecretBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToSecretItems(io.fabric8.kubernetes.api.model.Secret... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToSecretItems(Collection<Secret> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromSecretItems(io.fabric8.kubernetes.api.model.Secret... items) {
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromSecretItems(Collection<Secret> items) {
    for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSecretItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.SecretItemsNested<A> addNewSecretItem() {
    return new KubernetesListFluentImpl.SecretItemsNestedImpl();
  }
  public KubernetesListFluentImpl.SecretItemsNested<A> addNewSecretItemLike(Secret item) {
    return new KubernetesListFluentImpl.SecretItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.SecretItemsNested<A> setNewSecretItemLike(int index,Secret item) {
    return new KubernetesListFluentImpl.SecretItemsNestedImpl(index, item);
  }
  public A addToNodeItems(int index,Node item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NodeBuilder builder = new NodeBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToNodeItems(int index,Node item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    NodeBuilder builder = new NodeBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToNodeItems(io.fabric8.kubernetes.api.model.Node... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToNodeItems(Collection<Node> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromNodeItems(io.fabric8.kubernetes.api.model.Node... items) {
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromNodeItems(Collection<Node> items) {
    for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromNodeItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.NodeItemsNested<A> addNewNodeItem() {
    return new KubernetesListFluentImpl.NodeItemsNestedImpl();
  }
  public KubernetesListFluentImpl.NodeItemsNested<A> addNewNodeItemLike(Node item) {
    return new KubernetesListFluentImpl.NodeItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.NodeItemsNested<A> setNewNodeItemLike(int index,Node item) {
    return new KubernetesListFluentImpl.NodeItemsNestedImpl(index, item);
  }
  public A addToServiceAccountItems(int index,ServiceAccount item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ServiceAccountBuilder builder = new ServiceAccountBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToServiceAccountItems(int index,ServiceAccount item) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    ServiceAccountBuilder builder = new ServiceAccountBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToServiceAccountItems(Collection<ServiceAccount> items) {
    if (this.items == null) {this.items = new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();}
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromServiceAccountItems(io.fabric8.kubernetes.api.model.ServiceAccount... items) {
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceAccountItems(Collection<ServiceAccount> items) {
    for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceAccountItems(Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate) {
    if (items == null) return (A) this;
    final Iterator<VisitableBuilder<? extends HasMetadata,?>> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      VisitableBuilder<? extends HasMetadata,?> builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public KubernetesListFluentImpl.ServiceAccountItemsNested<A> addNewServiceAccountItem() {
    return new KubernetesListFluentImpl.ServiceAccountItemsNestedImpl();
  }
  public KubernetesListFluentImpl.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(ServiceAccount item) {
    return new KubernetesListFluentImpl.ServiceAccountItemsNestedImpl(-1, item);
  }
  public KubernetesListFluentImpl.ServiceAccountItemsNested<A> setNewServiceAccountItemLike(int index,ServiceAccount item) {
    return new KubernetesListFluentImpl.ServiceAccountItemsNestedImpl(index, item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ListMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ListMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public KubernetesListFluentImpl.MetadataNested<A> withNewMetadata() {
    return new KubernetesListFluentImpl.MetadataNestedImpl();
  }
  public KubernetesListFluentImpl.MetadataNested<A> withNewMetadataLike(ListMeta item) {
    return new KubernetesListFluentImpl.MetadataNestedImpl(item);
  }
  public KubernetesListFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public KubernetesListFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ListMetaBuilder().build());
  }
  public KubernetesListFluentImpl.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesListFluentImpl that = (KubernetesListFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata); }
    sb.append("}");
    return sb.toString();
  }
  class LimitRangeItemsNestedImpl<N> extends LimitRangeFluentImpl<KubernetesListFluentImpl.LimitRangeItemsNested<N>> implements KubernetesListFluentImpl.LimitRangeItemsNested<N>,Nested<N>{
    LimitRangeItemsNestedImpl(int index,LimitRange item) {
      this.index = index;
      this.builder = new LimitRangeBuilder(this, item);
    }
    LimitRangeItemsNestedImpl() {
      this.index = -1;
      this.builder = new LimitRangeBuilder(this);
    }
    LimitRangeBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endLimitRangeItem() {
      return and();
    }
    
  }
  class APIServiceItemsNestedImpl<N> extends APIServiceFluentImpl<KubernetesListFluentImpl.APIServiceItemsNested<N>> implements KubernetesListFluentImpl.APIServiceItemsNested<N>,Nested<N>{
    APIServiceItemsNestedImpl(int index,APIService item) {
      this.index = index;
      this.builder = new APIServiceBuilder(this, item);
    }
    APIServiceItemsNestedImpl() {
      this.index = -1;
      this.builder = new APIServiceBuilder(this);
    }
    APIServiceBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endAPIServiceItem() {
      return and();
    }
    
  }
  class NamespaceItemsNestedImpl<N> extends NamespaceFluentImpl<KubernetesListFluentImpl.NamespaceItemsNested<N>> implements KubernetesListFluentImpl.NamespaceItemsNested<N>,Nested<N>{
    NamespaceItemsNestedImpl(int index,Namespace item) {
      this.index = index;
      this.builder = new NamespaceBuilder(this, item);
    }
    NamespaceItemsNestedImpl() {
      this.index = -1;
      this.builder = new NamespaceBuilder(this);
    }
    NamespaceBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endNamespaceItem() {
      return and();
    }
    
  }
  class ServiceItemsNestedImpl<N> extends ServiceFluentImpl<KubernetesListFluentImpl.ServiceItemsNested<N>> implements KubernetesListFluentImpl.ServiceItemsNested<N>,Nested<N>{
    ServiceItemsNestedImpl(int index,Service item) {
      this.index = index;
      this.builder = new ServiceBuilder(this, item);
    }
    ServiceItemsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceBuilder(this);
    }
    ServiceBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endServiceItem() {
      return and();
    }
    
  }
  class ReplicationControllerItemsNestedImpl<N> extends ReplicationControllerFluentImpl<KubernetesListFluentImpl.ReplicationControllerItemsNested<N>> implements KubernetesListFluentImpl.ReplicationControllerItemsNested<N>,Nested<N>{
    ReplicationControllerItemsNestedImpl(int index,ReplicationController item) {
      this.index = index;
      this.builder = new ReplicationControllerBuilder(this, item);
    }
    ReplicationControllerItemsNestedImpl() {
      this.index = -1;
      this.builder = new ReplicationControllerBuilder(this);
    }
    ReplicationControllerBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endReplicationControllerItem() {
      return and();
    }
    
  }
  class PodTemplateItemsNestedImpl<N> extends PodTemplateFluentImpl<KubernetesListFluentImpl.PodTemplateItemsNested<N>> implements KubernetesListFluentImpl.PodTemplateItemsNested<N>,Nested<N>{
    PodTemplateItemsNestedImpl(int index,PodTemplate item) {
      this.index = index;
      this.builder = new PodTemplateBuilder(this, item);
    }
    PodTemplateItemsNestedImpl() {
      this.index = -1;
      this.builder = new PodTemplateBuilder(this);
    }
    PodTemplateBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPodTemplateItem() {
      return and();
    }
    
  }
  class EventItemsNestedImpl<N> extends EventFluentImpl<KubernetesListFluentImpl.EventItemsNested<N>> implements KubernetesListFluentImpl.EventItemsNested<N>,Nested<N>{
    EventItemsNestedImpl(int index,Event item) {
      this.index = index;
      this.builder = new EventBuilder(this, item);
    }
    EventItemsNestedImpl() {
      this.index = -1;
      this.builder = new EventBuilder(this);
    }
    EventBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endEventItem() {
      return and();
    }
    
  }
  class PersistentVolumeItemsNestedImpl<N> extends PersistentVolumeFluentImpl<KubernetesListFluentImpl.PersistentVolumeItemsNested<N>> implements KubernetesListFluentImpl.PersistentVolumeItemsNested<N>,Nested<N>{
    PersistentVolumeItemsNestedImpl(int index,PersistentVolume item) {
      this.index = index;
      this.builder = new PersistentVolumeBuilder(this, item);
    }
    PersistentVolumeItemsNestedImpl() {
      this.index = -1;
      this.builder = new PersistentVolumeBuilder(this);
    }
    PersistentVolumeBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPersistentVolumeItem() {
      return and();
    }
    
  }
  class PersistentVolumeClaimItemsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<KubernetesListFluentImpl.PersistentVolumeClaimItemsNested<N>> implements KubernetesListFluentImpl.PersistentVolumeClaimItemsNested<N>,Nested<N>{
    PersistentVolumeClaimItemsNestedImpl(int index,PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimItemsNestedImpl() {
      this.index = -1;
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPersistentVolumeClaimItem() {
      return and();
    }
    
  }
  class GenericKubernetesResourceItemsNestedImpl<N> extends GenericKubernetesResourceFluentImpl<KubernetesListFluentImpl.GenericKubernetesResourceItemsNested<N>> implements KubernetesListFluentImpl.GenericKubernetesResourceItemsNested<N>,Nested<N>{
    GenericKubernetesResourceItemsNestedImpl(int index,GenericKubernetesResource item) {
      this.index = index;
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceItemsNestedImpl() {
      this.index = -1;
      this.builder = new GenericKubernetesResourceBuilder(this);
    }
    GenericKubernetesResourceBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endGenericKubernetesResourceItem() {
      return and();
    }
    
  }
  class EndpointsItemsNestedImpl<N> extends EndpointsFluentImpl<KubernetesListFluentImpl.EndpointsItemsNested<N>> implements KubernetesListFluentImpl.EndpointsItemsNested<N>,Nested<N>{
    EndpointsItemsNestedImpl(int index,Endpoints item) {
      this.index = index;
      this.builder = new EndpointsBuilder(this, item);
    }
    EndpointsItemsNestedImpl() {
      this.index = -1;
      this.builder = new EndpointsBuilder(this);
    }
    EndpointsBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endEndpointsItem() {
      return and();
    }
    
  }
  class PodItemsNestedImpl<N> extends PodFluentImpl<KubernetesListFluentImpl.PodItemsNested<N>> implements KubernetesListFluentImpl.PodItemsNested<N>,Nested<N>{
    PodItemsNestedImpl(int index,Pod item) {
      this.index = index;
      this.builder = new PodBuilder(this, item);
    }
    PodItemsNestedImpl() {
      this.index = -1;
      this.builder = new PodBuilder(this);
    }
    PodBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endPodItem() {
      return and();
    }
    
  }
  class ConfigMapItemsNestedImpl<N> extends ConfigMapFluentImpl<KubernetesListFluentImpl.ConfigMapItemsNested<N>> implements KubernetesListFluentImpl.ConfigMapItemsNested<N>,Nested<N>{
    ConfigMapItemsNestedImpl(int index,ConfigMap item) {
      this.index = index;
      this.builder = new ConfigMapBuilder(this, item);
    }
    ConfigMapItemsNestedImpl() {
      this.index = -1;
      this.builder = new ConfigMapBuilder(this);
    }
    ConfigMapBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endConfigMapItem() {
      return and();
    }
    
  }
  class ComponentStatusItemsNestedImpl<N> extends ComponentStatusFluentImpl<KubernetesListFluentImpl.ComponentStatusItemsNested<N>> implements KubernetesListFluentImpl.ComponentStatusItemsNested<N>,Nested<N>{
    ComponentStatusItemsNestedImpl(int index,ComponentStatus item) {
      this.index = index;
      this.builder = new ComponentStatusBuilder(this, item);
    }
    ComponentStatusItemsNestedImpl() {
      this.index = -1;
      this.builder = new ComponentStatusBuilder(this);
    }
    ComponentStatusBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endComponentStatusItem() {
      return and();
    }
    
  }
  class BindingItemsNestedImpl<N> extends BindingFluentImpl<KubernetesListFluentImpl.BindingItemsNested<N>> implements KubernetesListFluentImpl.BindingItemsNested<N>,Nested<N>{
    BindingItemsNestedImpl(int index,Binding item) {
      this.index = index;
      this.builder = new BindingBuilder(this, item);
    }
    BindingItemsNestedImpl() {
      this.index = -1;
      this.builder = new BindingBuilder(this);
    }
    BindingBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endBindingItem() {
      return and();
    }
    
  }
  class ResourceQuotaItemsNestedImpl<N> extends ResourceQuotaFluentImpl<KubernetesListFluentImpl.ResourceQuotaItemsNested<N>> implements KubernetesListFluentImpl.ResourceQuotaItemsNested<N>,Nested<N>{
    ResourceQuotaItemsNestedImpl(int index,ResourceQuota item) {
      this.index = index;
      this.builder = new ResourceQuotaBuilder(this, item);
    }
    ResourceQuotaItemsNestedImpl() {
      this.index = -1;
      this.builder = new ResourceQuotaBuilder(this);
    }
    ResourceQuotaBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endResourceQuotaItem() {
      return and();
    }
    
  }
  class SecretItemsNestedImpl<N> extends SecretFluentImpl<KubernetesListFluentImpl.SecretItemsNested<N>> implements KubernetesListFluentImpl.SecretItemsNested<N>,Nested<N>{
    SecretItemsNestedImpl(int index,Secret item) {
      this.index = index;
      this.builder = new SecretBuilder(this, item);
    }
    SecretItemsNestedImpl() {
      this.index = -1;
      this.builder = new SecretBuilder(this);
    }
    SecretBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endSecretItem() {
      return and();
    }
    
  }
  class NodeItemsNestedImpl<N> extends NodeFluentImpl<KubernetesListFluentImpl.NodeItemsNested<N>> implements KubernetesListFluentImpl.NodeItemsNested<N>,Nested<N>{
    NodeItemsNestedImpl(int index,Node item) {
      this.index = index;
      this.builder = new NodeBuilder(this, item);
    }
    NodeItemsNestedImpl() {
      this.index = -1;
      this.builder = new NodeBuilder(this);
    }
    NodeBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endNodeItem() {
      return and();
    }
    
  }
  class ServiceAccountItemsNestedImpl<N> extends ServiceAccountFluentImpl<KubernetesListFluentImpl.ServiceAccountItemsNested<N>> implements KubernetesListFluentImpl.ServiceAccountItemsNested<N>,Nested<N>{
    ServiceAccountItemsNestedImpl(int index,ServiceAccount item) {
      this.index = index;
      this.builder = new ServiceAccountBuilder(this, item);
    }
    ServiceAccountItemsNestedImpl() {
      this.index = -1;
      this.builder = new ServiceAccountBuilder(this);
    }
    ServiceAccountBuilder builder;
    int index;
    public N and() {
      return (N) KubernetesListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endServiceAccountItem() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ListMetaFluentImpl<KubernetesListFluentImpl.MetadataNested<N>> implements KubernetesListFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ListMeta item) {
      this.builder = new ListMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ListMetaBuilder(this);
    }
    ListMetaBuilder builder;
    public N and() {
      return (N) KubernetesListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}