package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MicroTimeBuilder extends MicroTimeFluentImpl<MicroTimeBuilder> implements VisitableBuilder<MicroTime,MicroTimeBuilder>{
  public MicroTimeBuilder() {
    this(false);
  }
  public MicroTimeBuilder(Boolean validationEnabled) {
    this(new MicroTime(), validationEnabled);
  }
  public MicroTimeBuilder(MicroTimeFluent<?> fluent) {
    this(fluent, false);
  }
  public MicroTimeBuilder(MicroTimeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MicroTime(), validationEnabled);
  }
  public MicroTimeBuilder(MicroTimeFluent<?> fluent,MicroTime instance) {
    this(fluent, instance, false);
  }
  public MicroTimeBuilder(MicroTimeFluent<?> fluent,MicroTime instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withTime(instance.getTime());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MicroTimeBuilder(MicroTime instance) {
    this(instance,false);
  }
  public MicroTimeBuilder(MicroTime instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withTime(instance.getTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MicroTimeFluent<?> fluent;
  Boolean validationEnabled;
  public MicroTime build() {
    MicroTime buildable = new MicroTime(fluent.getTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}