package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeConfigSourceBuilder extends NodeConfigSourceFluentImpl<NodeConfigSourceBuilder> implements VisitableBuilder<NodeConfigSource,NodeConfigSourceBuilder>{
  public NodeConfigSourceBuilder() {
    this(false);
  }
  public NodeConfigSourceBuilder(Boolean validationEnabled) {
    this(new NodeConfigSource(), validationEnabled);
  }
  public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeConfigSource(), validationEnabled);
  }
  public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent,NodeConfigSource instance) {
    this(fluent, instance, false);
  }
  public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent,NodeConfigSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeConfigSourceBuilder(NodeConfigSource instance) {
    this(instance,false);
  }
  public NodeConfigSourceBuilder(NodeConfigSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConfigMap(instance.getConfigMap());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeConfigSourceFluent<?> fluent;
  Boolean validationEnabled;
  public NodeConfigSource build() {
    NodeConfigSource buildable = new NodeConfigSource(fluent.getConfigMap());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}