package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeSelectorBuilder extends NodeSelectorFluentImpl<NodeSelectorBuilder> implements VisitableBuilder<NodeSelector,NodeSelectorBuilder>{
  public NodeSelectorBuilder() {
    this(false);
  }
  public NodeSelectorBuilder(Boolean validationEnabled) {
    this(new NodeSelector(), validationEnabled);
  }
  public NodeSelectorBuilder(NodeSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeSelectorBuilder(NodeSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeSelector(), validationEnabled);
  }
  public NodeSelectorBuilder(NodeSelectorFluent<?> fluent,NodeSelector instance) {
    this(fluent, instance, false);
  }
  public NodeSelectorBuilder(NodeSelectorFluent<?> fluent,NodeSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withNodeSelectorTerms(instance.getNodeSelectorTerms());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeSelectorBuilder(NodeSelector instance) {
    this(instance,false);
  }
  public NodeSelectorBuilder(NodeSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public NodeSelector build() {
    NodeSelector buildable = new NodeSelector(fluent.getNodeSelectorTerms());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}