package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface NodeStatusFluent<A extends NodeStatusFluent<A>> extends Fluent<A>{
  public A addToAddresses(int index,NodeAddress item);
  public A setToAddresses(int index,NodeAddress item);
  public A addToAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items);
  public A addAllToAddresses(Collection<NodeAddress> items);
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items);
  public A removeAllFromAddresses(Collection<NodeAddress> items);
  public A removeMatchingFromAddresses(Predicate<NodeAddressBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildAddresses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NodeAddress> getAddresses();
  public List<NodeAddress> buildAddresses();
  public NodeAddress buildAddress(int index);
  public NodeAddress buildFirstAddress();
  public NodeAddress buildLastAddress();
  public NodeAddress buildMatchingAddress(Predicate<NodeAddressBuilder> predicate);
  public Boolean hasMatchingAddress(Predicate<NodeAddressBuilder> predicate);
  public A withAddresses(List<NodeAddress> addresses);
  public A withAddresses(io.fabric8.kubernetes.api.model.NodeAddress... addresses);
  public Boolean hasAddresses();
  public A addNewAddress(String address,String type);
  public NodeStatusFluent.AddressesNested<A> addNewAddress();
  public NodeStatusFluent.AddressesNested<A> addNewAddressLike(NodeAddress item);
  public NodeStatusFluent.AddressesNested<A> setNewAddressLike(int index,NodeAddress item);
  public NodeStatusFluent.AddressesNested<A> editAddress(int index);
  public NodeStatusFluent.AddressesNested<A> editFirstAddress();
  public NodeStatusFluent.AddressesNested<A> editLastAddress();
  public NodeStatusFluent.AddressesNested<A> editMatchingAddress(Predicate<NodeAddressBuilder> predicate);
  public A addToAllocatable(String key,Quantity value);
  public A addToAllocatable(Map<String,Quantity> map);
  public A removeFromAllocatable(String key);
  public A removeFromAllocatable(Map<String,Quantity> map);
  public Map<String,Quantity> getAllocatable();
  public <K,V>A withAllocatable(Map<String,Quantity> allocatable);
  public Boolean hasAllocatable();
  public A addToCapacity(String key,Quantity value);
  public A addToCapacity(Map<String,Quantity> map);
  public A removeFromCapacity(String key);
  public A removeFromCapacity(Map<String,Quantity> map);
  public Map<String,Quantity> getCapacity();
  public <K,V>A withCapacity(Map<String,Quantity> capacity);
  public Boolean hasCapacity();
  public A addToConditions(int index,NodeCondition item);
  public A setToConditions(int index,NodeCondition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.NodeCondition... items);
  public A addAllToConditions(Collection<NodeCondition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.NodeCondition... items);
  public A removeAllFromConditions(Collection<NodeCondition> items);
  public A removeMatchingFromConditions(Predicate<NodeConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NodeCondition> getConditions();
  public List<NodeCondition> buildConditions();
  public NodeCondition buildCondition(int index);
  public NodeCondition buildFirstCondition();
  public NodeCondition buildLastCondition();
  public NodeCondition buildMatchingCondition(Predicate<NodeConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<NodeConditionBuilder> predicate);
  public A withConditions(List<NodeCondition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.NodeCondition... conditions);
  public Boolean hasConditions();
  public NodeStatusFluent.ConditionsNested<A> addNewCondition();
  public NodeStatusFluent.ConditionsNested<A> addNewConditionLike(NodeCondition item);
  public NodeStatusFluent.ConditionsNested<A> setNewConditionLike(int index,NodeCondition item);
  public NodeStatusFluent.ConditionsNested<A> editCondition(int index);
  public NodeStatusFluent.ConditionsNested<A> editFirstCondition();
  public NodeStatusFluent.ConditionsNested<A> editLastCondition();
  public NodeStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<NodeConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodeConfigStatus getConfig();
  public NodeConfigStatus buildConfig();
  public A withConfig(NodeConfigStatus config);
  public Boolean hasConfig();
  public NodeStatusFluent.ConfigNested<A> withNewConfig();
  public NodeStatusFluent.ConfigNested<A> withNewConfigLike(NodeConfigStatus item);
  public NodeStatusFluent.ConfigNested<A> editConfig();
  public NodeStatusFluent.ConfigNested<A> editOrNewConfig();
  public NodeStatusFluent.ConfigNested<A> editOrNewConfigLike(NodeConfigStatus item);
  
  /**
   * This method has been deprecated, please use method buildDaemonEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodeDaemonEndpoints getDaemonEndpoints();
  public NodeDaemonEndpoints buildDaemonEndpoints();
  public A withDaemonEndpoints(NodeDaemonEndpoints daemonEndpoints);
  public Boolean hasDaemonEndpoints();
  public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpoints();
  public NodeStatusFluent.DaemonEndpointsNested<A> withNewDaemonEndpointsLike(NodeDaemonEndpoints item);
  public NodeStatusFluent.DaemonEndpointsNested<A> editDaemonEndpoints();
  public NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpoints();
  public NodeStatusFluent.DaemonEndpointsNested<A> editOrNewDaemonEndpointsLike(NodeDaemonEndpoints item);
  public A addToImages(int index,ContainerImage item);
  public A setToImages(int index,ContainerImage item);
  public A addToImages(io.fabric8.kubernetes.api.model.ContainerImage... items);
  public A addAllToImages(Collection<ContainerImage> items);
  public A removeFromImages(io.fabric8.kubernetes.api.model.ContainerImage... items);
  public A removeAllFromImages(Collection<ContainerImage> items);
  public A removeMatchingFromImages(Predicate<ContainerImageBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ContainerImage> getImages();
  public List<ContainerImage> buildImages();
  public ContainerImage buildImage(int index);
  public ContainerImage buildFirstImage();
  public ContainerImage buildLastImage();
  public ContainerImage buildMatchingImage(Predicate<ContainerImageBuilder> predicate);
  public Boolean hasMatchingImage(Predicate<ContainerImageBuilder> predicate);
  public A withImages(List<ContainerImage> images);
  public A withImages(io.fabric8.kubernetes.api.model.ContainerImage... images);
  public Boolean hasImages();
  public NodeStatusFluent.ImagesNested<A> addNewImage();
  public NodeStatusFluent.ImagesNested<A> addNewImageLike(ContainerImage item);
  public NodeStatusFluent.ImagesNested<A> setNewImageLike(int index,ContainerImage item);
  public NodeStatusFluent.ImagesNested<A> editImage(int index);
  public NodeStatusFluent.ImagesNested<A> editFirstImage();
  public NodeStatusFluent.ImagesNested<A> editLastImage();
  public NodeStatusFluent.ImagesNested<A> editMatchingImage(Predicate<ContainerImageBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildNodeInfo instead.
   * @return The buildable object.
   */
  @Deprecated
  public NodeSystemInfo getNodeInfo();
  public NodeSystemInfo buildNodeInfo();
  public A withNodeInfo(NodeSystemInfo nodeInfo);
  public Boolean hasNodeInfo();
  public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfo();
  public NodeStatusFluent.NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item);
  public NodeStatusFluent.NodeInfoNested<A> editNodeInfo();
  public NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfo();
  public NodeStatusFluent.NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item);
  public String getPhase();
  public A withPhase(String phase);
  public Boolean hasPhase();
  public A addToVolumesAttached(int index,AttachedVolume item);
  public A setToVolumesAttached(int index,AttachedVolume item);
  public A addToVolumesAttached(io.fabric8.kubernetes.api.model.AttachedVolume... items);
  public A addAllToVolumesAttached(Collection<AttachedVolume> items);
  public A removeFromVolumesAttached(io.fabric8.kubernetes.api.model.AttachedVolume... items);
  public A removeAllFromVolumesAttached(Collection<AttachedVolume> items);
  public A removeMatchingFromVolumesAttached(Predicate<AttachedVolumeBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildVolumesAttached instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AttachedVolume> getVolumesAttached();
  public List<AttachedVolume> buildVolumesAttached();
  public AttachedVolume buildVolumesAttached(int index);
  public AttachedVolume buildFirstVolumesAttached();
  public AttachedVolume buildLastVolumesAttached();
  public AttachedVolume buildMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate);
  public Boolean hasMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate);
  public A withVolumesAttached(List<AttachedVolume> volumesAttached);
  public A withVolumesAttached(io.fabric8.kubernetes.api.model.AttachedVolume... volumesAttached);
  public Boolean hasVolumesAttached();
  public A addNewVolumesAttached(String devicePath,String name);
  public NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttached();
  public NodeStatusFluent.VolumesAttachedNested<A> addNewVolumesAttachedLike(AttachedVolume item);
  public NodeStatusFluent.VolumesAttachedNested<A> setNewVolumesAttachedLike(int index,AttachedVolume item);
  public NodeStatusFluent.VolumesAttachedNested<A> editVolumesAttached(int index);
  public NodeStatusFluent.VolumesAttachedNested<A> editFirstVolumesAttached();
  public NodeStatusFluent.VolumesAttachedNested<A> editLastVolumesAttached();
  public NodeStatusFluent.VolumesAttachedNested<A> editMatchingVolumesAttached(Predicate<AttachedVolumeBuilder> predicate);
  public A addToVolumesInUse(int index,String item);
  public A setToVolumesInUse(int index,String item);
  public A addToVolumesInUse(java.lang.String... items);
  public A addAllToVolumesInUse(Collection<String> items);
  public A removeFromVolumesInUse(java.lang.String... items);
  public A removeAllFromVolumesInUse(Collection<String> items);
  public List<String> getVolumesInUse();
  public String getVolumesInUse(int index);
  public String getFirstVolumesInUse();
  public String getLastVolumesInUse();
  public String getMatchingVolumesInUse(Predicate<String> predicate);
  public Boolean hasMatchingVolumesInUse(Predicate<String> predicate);
  public A withVolumesInUse(List<String> volumesInUse);
  public A withVolumesInUse(java.lang.String... volumesInUse);
  public Boolean hasVolumesInUse();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface AddressesNested<N> extends Nested<N>,NodeAddressFluent<NodeStatusFluent.AddressesNested<N>>{
    public N and();
    public N endAddress();
    
  }
  public interface ConditionsNested<N> extends Nested<N>,NodeConditionFluent<NodeStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface ConfigNested<N> extends Nested<N>,NodeConfigStatusFluent<NodeStatusFluent.ConfigNested<N>>{
    public N and();
    public N endConfig();
    
  }
  public interface DaemonEndpointsNested<N> extends Nested<N>,NodeDaemonEndpointsFluent<NodeStatusFluent.DaemonEndpointsNested<N>>{
    public N and();
    public N endDaemonEndpoints();
    
  }
  public interface ImagesNested<N> extends Nested<N>,ContainerImageFluent<NodeStatusFluent.ImagesNested<N>>{
    public N and();
    public N endImage();
    
  }
  public interface NodeInfoNested<N> extends Nested<N>,NodeSystemInfoFluent<NodeStatusFluent.NodeInfoNested<N>>{
    public N and();
    public N endNodeInfo();
    
  }
  public interface VolumesAttachedNested<N> extends Nested<N>,AttachedVolumeFluent<NodeStatusFluent.VolumesAttachedNested<N>>{
    public N and();
    public N endVolumesAttached();
    
  }
  
}