package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeBuilder extends PersistentVolumeFluentImpl<PersistentVolumeBuilder> implements VisitableBuilder<PersistentVolume,PersistentVolumeBuilder>{
  public PersistentVolumeBuilder() {
    this(false);
  }
  public PersistentVolumeBuilder(Boolean validationEnabled) {
    this(new PersistentVolume(), validationEnabled);
  }
  public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolume(), validationEnabled);
  }
  public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent,PersistentVolume instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeBuilder(PersistentVolumeFluent<?> fluent,PersistentVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeBuilder(PersistentVolume instance) {
    this(instance,false);
  }
  public PersistentVolumeBuilder(PersistentVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolume build() {
    PersistentVolume buildable = new PersistentVolume(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}