package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeClaimConditionBuilder extends PersistentVolumeClaimConditionFluentImpl<PersistentVolumeClaimConditionBuilder> implements VisitableBuilder<PersistentVolumeClaimCondition,PersistentVolumeClaimConditionBuilder>{
  public PersistentVolumeClaimConditionBuilder() {
    this(false);
  }
  public PersistentVolumeClaimConditionBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeClaimCondition(), validationEnabled);
  }
  public PersistentVolumeClaimConditionBuilder(PersistentVolumeClaimConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeClaimConditionBuilder(PersistentVolumeClaimConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolumeClaimCondition(), validationEnabled);
  }
  public PersistentVolumeClaimConditionBuilder(PersistentVolumeClaimConditionFluent<?> fluent,PersistentVolumeClaimCondition instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeClaimConditionBuilder(PersistentVolumeClaimConditionFluent<?> fluent,PersistentVolumeClaimCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeClaimConditionBuilder(PersistentVolumeClaimCondition instance) {
    this(instance,false);
  }
  public PersistentVolumeClaimConditionBuilder(PersistentVolumeClaimCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeClaimConditionFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolumeClaimCondition build() {
    PersistentVolumeClaimCondition buildable = new PersistentVolumeClaimCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}