package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeClaimSpecBuilder extends PersistentVolumeClaimSpecFluentImpl<PersistentVolumeClaimSpecBuilder> implements VisitableBuilder<PersistentVolumeClaimSpec,PersistentVolumeClaimSpecBuilder>{
  public PersistentVolumeClaimSpecBuilder() {
    this(false);
  }
  public PersistentVolumeClaimSpecBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeClaimSpec(), validationEnabled);
  }
  public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolumeClaimSpec(), validationEnabled);
  }
  public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent,PersistentVolumeClaimSpec instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpecFluent<?> fluent,PersistentVolumeClaimSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAccessModes(instance.getAccessModes());
      fluent.withDataSource(instance.getDataSource());
      fluent.withDataSourceRef(instance.getDataSourceRef());
      fluent.withResources(instance.getResources());
      fluent.withSelector(instance.getSelector());
      fluent.withStorageClassName(instance.getStorageClassName());
      fluent.withVolumeMode(instance.getVolumeMode());
      fluent.withVolumeName(instance.getVolumeName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpec instance) {
    this(instance,false);
  }
  public PersistentVolumeClaimSpecBuilder(PersistentVolumeClaimSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAccessModes(instance.getAccessModes());
      this.withDataSource(instance.getDataSource());
      this.withDataSourceRef(instance.getDataSourceRef());
      this.withResources(instance.getResources());
      this.withSelector(instance.getSelector());
      this.withStorageClassName(instance.getStorageClassName());
      this.withVolumeMode(instance.getVolumeMode());
      this.withVolumeName(instance.getVolumeName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeClaimSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolumeClaimSpec build() {
    PersistentVolumeClaimSpec buildable = new PersistentVolumeClaimSpec(fluent.getAccessModes(),fluent.getDataSource(),fluent.getDataSourceRef(),fluent.getResources(),fluent.getSelector(),fluent.getStorageClassName(),fluent.getVolumeMode(),fluent.getVolumeName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}