package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodAffinityBuilder extends PodAffinityFluentImpl<PodAffinityBuilder> implements VisitableBuilder<PodAffinity,PodAffinityBuilder>{
  public PodAffinityBuilder() {
    this(false);
  }
  public PodAffinityBuilder(Boolean validationEnabled) {
    this(new PodAffinity(), validationEnabled);
  }
  public PodAffinityBuilder(PodAffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAffinityBuilder(PodAffinityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodAffinity(), validationEnabled);
  }
  public PodAffinityBuilder(PodAffinityFluent<?> fluent,PodAffinity instance) {
    this(fluent, instance, false);
  }
  public PodAffinityBuilder(PodAffinityFluent<?> fluent,PodAffinity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodAffinityBuilder(PodAffinity instance) {
    this(instance,false);
  }
  public PodAffinityBuilder(PodAffinity instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodAffinityFluent<?> fluent;
  Boolean validationEnabled;
  public PodAffinity build() {
    PodAffinity buildable = new PodAffinity(fluent.getPreferredDuringSchedulingIgnoredDuringExecution(),fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}