package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodAntiAffinityBuilder extends PodAntiAffinityFluentImpl<PodAntiAffinityBuilder> implements VisitableBuilder<PodAntiAffinity,PodAntiAffinityBuilder>{
  public PodAntiAffinityBuilder() {
    this(false);
  }
  public PodAntiAffinityBuilder(Boolean validationEnabled) {
    this(new PodAntiAffinity(), validationEnabled);
  }
  public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent) {
    this(fluent, false);
  }
  public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodAntiAffinity(), validationEnabled);
  }
  public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent,PodAntiAffinity instance) {
    this(fluent, instance, false);
  }
  public PodAntiAffinityBuilder(PodAntiAffinityFluent<?> fluent,PodAntiAffinity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodAntiAffinityBuilder(PodAntiAffinity instance) {
    this(instance,false);
  }
  public PodAntiAffinityBuilder(PodAntiAffinity instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
      this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodAntiAffinityFluent<?> fluent;
  Boolean validationEnabled;
  public PodAntiAffinity build() {
    PodAntiAffinity buildable = new PodAntiAffinity(fluent.getPreferredDuringSchedulingIgnoredDuringExecution(),fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}