package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceAccountListFluent<A extends ServiceAccountListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,ServiceAccount item);
  public A setToItems(int index,ServiceAccount item);
  public A addToItems(io.fabric8.kubernetes.api.model.ServiceAccount... items);
  public A addAllToItems(Collection<ServiceAccount> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.ServiceAccount... items);
  public A removeAllFromItems(Collection<ServiceAccount> items);
  public A removeMatchingFromItems(Predicate<ServiceAccountBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServiceAccount> getItems();
  public List<ServiceAccount> buildItems();
  public ServiceAccount buildItem(int index);
  public ServiceAccount buildFirstItem();
  public ServiceAccount buildLastItem();
  public ServiceAccount buildMatchingItem(Predicate<ServiceAccountBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<ServiceAccountBuilder> predicate);
  public A withItems(List<ServiceAccount> items);
  public A withItems(io.fabric8.kubernetes.api.model.ServiceAccount... items);
  public Boolean hasItems();
  public ServiceAccountListFluent.ItemsNested<A> addNewItem();
  public ServiceAccountListFluent.ItemsNested<A> addNewItemLike(ServiceAccount item);
  public ServiceAccountListFluent.ItemsNested<A> setNewItemLike(int index,ServiceAccount item);
  public ServiceAccountListFluent.ItemsNested<A> editItem(int index);
  public ServiceAccountListFluent.ItemsNested<A> editFirstItem();
  public ServiceAccountListFluent.ItemsNested<A> editLastItem();
  public ServiceAccountListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceAccountBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata();
  public ListMeta buildMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public ServiceAccountListFluent.MetadataNested<A> withNewMetadata();
  public ServiceAccountListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
  public ServiceAccountListFluent.MetadataNested<A> editMetadata();
  public ServiceAccountListFluent.MetadataNested<A> editOrNewMetadata();
  public ServiceAccountListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,ServiceAccountFluent<ServiceAccountListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ServiceAccountListFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  
}