package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ServiceSpecFluent<A extends ServiceSpecFluent<A>> extends Fluent<A>{
  public Boolean getAllocateLoadBalancerNodePorts();
  public A withAllocateLoadBalancerNodePorts(Boolean allocateLoadBalancerNodePorts);
  public Boolean hasAllocateLoadBalancerNodePorts();
  public String getClusterIP();
  public A withClusterIP(String clusterIP);
  public Boolean hasClusterIP();
  public A addToClusterIPs(int index,String item);
  public A setToClusterIPs(int index,String item);
  public A addToClusterIPs(java.lang.String... items);
  public A addAllToClusterIPs(Collection<String> items);
  public A removeFromClusterIPs(java.lang.String... items);
  public A removeAllFromClusterIPs(Collection<String> items);
  public List<String> getClusterIPs();
  public String getClusterIP(int index);
  public String getFirstClusterIP();
  public String getLastClusterIP();
  public String getMatchingClusterIP(Predicate<String> predicate);
  public Boolean hasMatchingClusterIP(Predicate<String> predicate);
  public A withClusterIPs(List<String> clusterIPs);
  public A withClusterIPs(java.lang.String... clusterIPs);
  public Boolean hasClusterIPs();
  public A addToExternalIPs(int index,String item);
  public A setToExternalIPs(int index,String item);
  public A addToExternalIPs(java.lang.String... items);
  public A addAllToExternalIPs(Collection<String> items);
  public A removeFromExternalIPs(java.lang.String... items);
  public A removeAllFromExternalIPs(Collection<String> items);
  public List<String> getExternalIPs();
  public String getExternalIP(int index);
  public String getFirstExternalIP();
  public String getLastExternalIP();
  public String getMatchingExternalIP(Predicate<String> predicate);
  public Boolean hasMatchingExternalIP(Predicate<String> predicate);
  public A withExternalIPs(List<String> externalIPs);
  public A withExternalIPs(java.lang.String... externalIPs);
  public Boolean hasExternalIPs();
  public String getExternalName();
  public A withExternalName(String externalName);
  public Boolean hasExternalName();
  public String getExternalTrafficPolicy();
  public A withExternalTrafficPolicy(String externalTrafficPolicy);
  public Boolean hasExternalTrafficPolicy();
  public Integer getHealthCheckNodePort();
  public A withHealthCheckNodePort(Integer healthCheckNodePort);
  public Boolean hasHealthCheckNodePort();
  public String getInternalTrafficPolicy();
  public A withInternalTrafficPolicy(String internalTrafficPolicy);
  public Boolean hasInternalTrafficPolicy();
  public A addToIpFamilies(int index,String item);
  public A setToIpFamilies(int index,String item);
  public A addToIpFamilies(java.lang.String... items);
  public A addAllToIpFamilies(Collection<String> items);
  public A removeFromIpFamilies(java.lang.String... items);
  public A removeAllFromIpFamilies(Collection<String> items);
  public List<String> getIpFamilies();
  public String getIpFamily(int index);
  public String getFirstIpFamily();
  public String getLastIpFamily();
  public String getMatchingIpFamily(Predicate<String> predicate);
  public Boolean hasMatchingIpFamily(Predicate<String> predicate);
  public A withIpFamilies(List<String> ipFamilies);
  public A withIpFamilies(java.lang.String... ipFamilies);
  public Boolean hasIpFamilies();
  public String getIpFamilyPolicy();
  public A withIpFamilyPolicy(String ipFamilyPolicy);
  public Boolean hasIpFamilyPolicy();
  public String getLoadBalancerClass();
  public A withLoadBalancerClass(String loadBalancerClass);
  public Boolean hasLoadBalancerClass();
  public String getLoadBalancerIP();
  public A withLoadBalancerIP(String loadBalancerIP);
  public Boolean hasLoadBalancerIP();
  public A addToLoadBalancerSourceRanges(int index,String item);
  public A setToLoadBalancerSourceRanges(int index,String item);
  public A addToLoadBalancerSourceRanges(java.lang.String... items);
  public A addAllToLoadBalancerSourceRanges(Collection<String> items);
  public A removeFromLoadBalancerSourceRanges(java.lang.String... items);
  public A removeAllFromLoadBalancerSourceRanges(Collection<String> items);
  public List<String> getLoadBalancerSourceRanges();
  public String getLoadBalancerSourceRange(int index);
  public String getFirstLoadBalancerSourceRange();
  public String getLastLoadBalancerSourceRange();
  public String getMatchingLoadBalancerSourceRange(Predicate<String> predicate);
  public Boolean hasMatchingLoadBalancerSourceRange(Predicate<String> predicate);
  public A withLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges);
  public A withLoadBalancerSourceRanges(java.lang.String... loadBalancerSourceRanges);
  public Boolean hasLoadBalancerSourceRanges();
  public A addToPorts(int index,ServicePort item);
  public A setToPorts(int index,ServicePort item);
  public A addToPorts(io.fabric8.kubernetes.api.model.ServicePort... items);
  public A addAllToPorts(Collection<ServicePort> items);
  public A removeFromPorts(io.fabric8.kubernetes.api.model.ServicePort... items);
  public A removeAllFromPorts(Collection<ServicePort> items);
  public A removeMatchingFromPorts(Predicate<ServicePortBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ServicePort> getPorts();
  public List<ServicePort> buildPorts();
  public ServicePort buildPort(int index);
  public ServicePort buildFirstPort();
  public ServicePort buildLastPort();
  public ServicePort buildMatchingPort(Predicate<ServicePortBuilder> predicate);
  public Boolean hasMatchingPort(Predicate<ServicePortBuilder> predicate);
  public A withPorts(List<ServicePort> ports);
  public A withPorts(io.fabric8.kubernetes.api.model.ServicePort... ports);
  public Boolean hasPorts();
  public ServiceSpecFluent.PortsNested<A> addNewPort();
  public ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item);
  public ServiceSpecFluent.PortsNested<A> setNewPortLike(int index,ServicePort item);
  public ServiceSpecFluent.PortsNested<A> editPort(int index);
  public ServiceSpecFluent.PortsNested<A> editFirstPort();
  public ServiceSpecFluent.PortsNested<A> editLastPort();
  public ServiceSpecFluent.PortsNested<A> editMatchingPort(Predicate<ServicePortBuilder> predicate);
  public Boolean getPublishNotReadyAddresses();
  public A withPublishNotReadyAddresses(Boolean publishNotReadyAddresses);
  public Boolean hasPublishNotReadyAddresses();
  public A addToSelector(String key,String value);
  public A addToSelector(Map<String,String> map);
  public A removeFromSelector(String key);
  public A removeFromSelector(Map<String,String> map);
  public Map<String,String> getSelector();
  public <K,V>A withSelector(Map<String,String> selector);
  public Boolean hasSelector();
  public String getSessionAffinity();
  public A withSessionAffinity(String sessionAffinity);
  public Boolean hasSessionAffinity();
  
  /**
   * This method has been deprecated, please use method buildSessionAffinityConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public SessionAffinityConfig getSessionAffinityConfig();
  public SessionAffinityConfig buildSessionAffinityConfig();
  public A withSessionAffinityConfig(SessionAffinityConfig sessionAffinityConfig);
  public Boolean hasSessionAffinityConfig();
  public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfig();
  public ServiceSpecFluent.SessionAffinityConfigNested<A> withNewSessionAffinityConfigLike(SessionAffinityConfig item);
  public ServiceSpecFluent.SessionAffinityConfigNested<A> editSessionAffinityConfig();
  public ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfig();
  public ServiceSpecFluent.SessionAffinityConfigNested<A> editOrNewSessionAffinityConfigLike(SessionAffinityConfig item);
  public String getType();
  public A withType(String type);
  public Boolean hasType();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withAllocateLoadBalancerNodePorts();
  public A withPublishNotReadyAddresses();
  public interface PortsNested<N> extends Nested<N>,ServicePortFluent<ServiceSpecFluent.PortsNested<N>>{
    public N and();
    public N endPort();
    
  }
  public interface SessionAffinityConfigNested<N> extends Nested<N>,SessionAffinityConfigFluent<ServiceSpecFluent.SessionAffinityConfigNested<N>>{
    public N and();
    public N endSessionAffinityConfig();
    
  }
  
}