package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatusCauseBuilder extends StatusCauseFluentImpl<StatusCauseBuilder> implements VisitableBuilder<StatusCause,StatusCauseBuilder>{
  public StatusCauseBuilder() {
    this(false);
  }
  public StatusCauseBuilder(Boolean validationEnabled) {
    this(new StatusCause(), validationEnabled);
  }
  public StatusCauseBuilder(StatusCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public StatusCauseBuilder(StatusCauseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatusCause(), validationEnabled);
  }
  public StatusCauseBuilder(StatusCauseFluent<?> fluent,StatusCause instance) {
    this(fluent, instance, false);
  }
  public StatusCauseBuilder(StatusCauseFluent<?> fluent,StatusCause instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withField(instance.getField());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StatusCauseBuilder(StatusCause instance) {
    this(instance,false);
  }
  public StatusCauseBuilder(StatusCause instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withField(instance.getField());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StatusCauseFluent<?> fluent;
  Boolean validationEnabled;
  public StatusCause build() {
    StatusCause buildable = new StatusCause(fluent.getField(),fluent.getMessage(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}