package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeBuilder extends VolumeFluentImpl<VolumeBuilder> implements VisitableBuilder<Volume,VolumeBuilder>{
  public VolumeBuilder() {
    this(false);
  }
  public VolumeBuilder(Boolean validationEnabled) {
    this(new Volume(), validationEnabled);
  }
  public VolumeBuilder(VolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeBuilder(VolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Volume(), validationEnabled);
  }
  public VolumeBuilder(VolumeFluent<?> fluent,Volume instance) {
    this(fluent, instance, false);
  }
  public VolumeBuilder(VolumeFluent<?> fluent,Volume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
      fluent.withAzureDisk(instance.getAzureDisk());
      fluent.withAzureFile(instance.getAzureFile());
      fluent.withCephfs(instance.getCephfs());
      fluent.withCinder(instance.getCinder());
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withCsi(instance.getCsi());
      fluent.withDownwardAPI(instance.getDownwardAPI());
      fluent.withEmptyDir(instance.getEmptyDir());
      fluent.withEphemeral(instance.getEphemeral());
      fluent.withFc(instance.getFc());
      fluent.withFlexVolume(instance.getFlexVolume());
      fluent.withFlocker(instance.getFlocker());
      fluent.withGcePersistentDisk(instance.getGcePersistentDisk());
      fluent.withGitRepo(instance.getGitRepo());
      fluent.withGlusterfs(instance.getGlusterfs());
      fluent.withHostPath(instance.getHostPath());
      fluent.withIscsi(instance.getIscsi());
      fluent.withName(instance.getName());
      fluent.withNfs(instance.getNfs());
      fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      fluent.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
      fluent.withPortworxVolume(instance.getPortworxVolume());
      fluent.withProjected(instance.getProjected());
      fluent.withQuobyte(instance.getQuobyte());
      fluent.withRbd(instance.getRbd());
      fluent.withScaleIO(instance.getScaleIO());
      fluent.withSecret(instance.getSecret());
      fluent.withStorageos(instance.getStorageos());
      fluent.withVsphereVolume(instance.getVsphereVolume());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumeBuilder(Volume instance) {
    this(instance,false);
  }
  public VolumeBuilder(Volume instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
      this.withAzureDisk(instance.getAzureDisk());
      this.withAzureFile(instance.getAzureFile());
      this.withCephfs(instance.getCephfs());
      this.withCinder(instance.getCinder());
      this.withConfigMap(instance.getConfigMap());
      this.withCsi(instance.getCsi());
      this.withDownwardAPI(instance.getDownwardAPI());
      this.withEmptyDir(instance.getEmptyDir());
      this.withEphemeral(instance.getEphemeral());
      this.withFc(instance.getFc());
      this.withFlexVolume(instance.getFlexVolume());
      this.withFlocker(instance.getFlocker());
      this.withGcePersistentDisk(instance.getGcePersistentDisk());
      this.withGitRepo(instance.getGitRepo());
      this.withGlusterfs(instance.getGlusterfs());
      this.withHostPath(instance.getHostPath());
      this.withIscsi(instance.getIscsi());
      this.withName(instance.getName());
      this.withNfs(instance.getNfs());
      this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
      this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
      this.withPortworxVolume(instance.getPortworxVolume());
      this.withProjected(instance.getProjected());
      this.withQuobyte(instance.getQuobyte());
      this.withRbd(instance.getRbd());
      this.withScaleIO(instance.getScaleIO());
      this.withSecret(instance.getSecret());
      this.withStorageos(instance.getStorageos());
      this.withVsphereVolume(instance.getVsphereVolume());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumeFluent<?> fluent;
  Boolean validationEnabled;
  public Volume build() {
    Volume buildable = new Volume(fluent.getAwsElasticBlockStore(),fluent.getAzureDisk(),fluent.getAzureFile(),fluent.getCephfs(),fluent.getCinder(),fluent.getConfigMap(),fluent.getCsi(),fluent.getDownwardAPI(),fluent.getEmptyDir(),fluent.getEphemeral(),fluent.getFc(),fluent.getFlexVolume(),fluent.getFlocker(),fluent.getGcePersistentDisk(),fluent.getGitRepo(),fluent.getGlusterfs(),fluent.getHostPath(),fluent.getIscsi(),fluent.getName(),fluent.getNfs(),fluent.getPersistentVolumeClaim(),fluent.getPhotonPersistentDisk(),fluent.getPortworxVolume(),fluent.getProjected(),fluent.getQuobyte(),fluent.getRbd(),fluent.getScaleIO(),fluent.getSecret(),fluent.getStorageos(),fluent.getVsphereVolume());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}