package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VsphereVirtualDiskVolumeSourceBuilder extends VsphereVirtualDiskVolumeSourceFluentImpl<VsphereVirtualDiskVolumeSourceBuilder> implements VisitableBuilder<VsphereVirtualDiskVolumeSource,VsphereVirtualDiskVolumeSourceBuilder>{
  public VsphereVirtualDiskVolumeSourceBuilder() {
    this(false);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(Boolean validationEnabled) {
    this(new VsphereVirtualDiskVolumeSource(), validationEnabled);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VsphereVirtualDiskVolumeSource(), validationEnabled);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSourceFluent<?> fluent,VsphereVirtualDiskVolumeSource instance) {
    this(fluent, instance, false);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSourceFluent<?> fluent,VsphereVirtualDiskVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withStoragePolicyID(instance.getStoragePolicyID());
      fluent.withStoragePolicyName(instance.getStoragePolicyName());
      fluent.withVolumePath(instance.getVolumePath());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSource instance) {
    this(instance,false);
  }
  public VsphereVirtualDiskVolumeSourceBuilder(VsphereVirtualDiskVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withStoragePolicyID(instance.getStoragePolicyID());
      this.withStoragePolicyName(instance.getStoragePolicyName());
      this.withVolumePath(instance.getVolumePath());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VsphereVirtualDiskVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public VsphereVirtualDiskVolumeSource build() {
    VsphereVirtualDiskVolumeSource buildable = new VsphereVirtualDiskVolumeSource(fluent.getFsType(),fluent.getStoragePolicyID(),fluent.getStoragePolicyName(),fluent.getVolumePath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}