package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CephFSVolumeSourceBuilder extends CephFSVolumeSourceFluentImpl<CephFSVolumeSourceBuilder> implements VisitableBuilder<CephFSVolumeSource,CephFSVolumeSourceBuilder>{
  public CephFSVolumeSourceBuilder() {
    this(false);
  }
  public CephFSVolumeSourceBuilder(Boolean validationEnabled) {
    this(new CephFSVolumeSource(), validationEnabled);
  }
  public CephFSVolumeSourceBuilder(CephFSVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CephFSVolumeSourceBuilder(CephFSVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CephFSVolumeSource(), validationEnabled);
  }
  public CephFSVolumeSourceBuilder(CephFSVolumeSourceFluent<?> fluent,CephFSVolumeSource instance) {
    this(fluent, instance, false);
  }
  public CephFSVolumeSourceBuilder(CephFSVolumeSourceFluent<?> fluent,CephFSVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMonitors(instance.getMonitors());
      fluent.withPath(instance.getPath());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretFile(instance.getSecretFile());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CephFSVolumeSourceBuilder(CephFSVolumeSource instance) {
    this(instance,false);
  }
  public CephFSVolumeSourceBuilder(CephFSVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMonitors(instance.getMonitors());
      this.withPath(instance.getPath());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretFile(instance.getSecretFile());
      this.withSecretRef(instance.getSecretRef());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CephFSVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public CephFSVolumeSource build() {
    CephFSVolumeSource buildable = new CephFSVolumeSource(fluent.getMonitors(),fluent.getPath(),fluent.getReadOnly(),fluent.getSecretFile(),fluent.getSecretRef(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}