package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapEnvSourceBuilder extends ConfigMapEnvSourceFluentImpl<ConfigMapEnvSourceBuilder> implements VisitableBuilder<ConfigMapEnvSource,ConfigMapEnvSourceBuilder>{
  public ConfigMapEnvSourceBuilder() {
    this(false);
  }
  public ConfigMapEnvSourceBuilder(Boolean validationEnabled) {
    this(new ConfigMapEnvSource(), validationEnabled);
  }
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapEnvSource(), validationEnabled);
  }
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSourceFluent<?> fluent,ConfigMapEnvSource instance) {
    this(fluent, instance, false);
  }
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSourceFluent<?> fluent,ConfigMapEnvSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withOptional(instance.getOptional());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSource instance) {
    this(instance,false);
  }
  public ConfigMapEnvSourceBuilder(ConfigMapEnvSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withOptional(instance.getOptional());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapEnvSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapEnvSource build() {
    ConfigMapEnvSource buildable = new ConfigMapEnvSource(fluent.getName(),fluent.getOptional());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}