package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ListOptionsBuilder extends ListOptionsFluentImpl<ListOptionsBuilder> implements VisitableBuilder<ListOptions,ListOptionsBuilder>{
  public ListOptionsBuilder() {
    this(false);
  }
  public ListOptionsBuilder(Boolean validationEnabled) {
    this(new ListOptions(), validationEnabled);
  }
  public ListOptionsBuilder(ListOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public ListOptionsBuilder(ListOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ListOptions(), validationEnabled);
  }
  public ListOptionsBuilder(ListOptionsFluent<?> fluent,ListOptions instance) {
    this(fluent, instance, false);
  }
  public ListOptionsBuilder(ListOptionsFluent<?> fluent,ListOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAllowWatchBookmarks(instance.getAllowWatchBookmarks());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withContinue(instance.getContinue());
      fluent.withFieldSelector(instance.getFieldSelector());
      fluent.withKind(instance.getKind());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withLimit(instance.getLimit());
      fluent.withResourceVersion(instance.getResourceVersion());
      fluent.withResourceVersionMatch(instance.getResourceVersionMatch());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withWatch(instance.getWatch());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ListOptionsBuilder(ListOptions instance) {
    this(instance,false);
  }
  public ListOptionsBuilder(ListOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAllowWatchBookmarks(instance.getAllowWatchBookmarks());
      this.withApiVersion(instance.getApiVersion());
      this.withContinue(instance.getContinue());
      this.withFieldSelector(instance.getFieldSelector());
      this.withKind(instance.getKind());
      this.withLabelSelector(instance.getLabelSelector());
      this.withLimit(instance.getLimit());
      this.withResourceVersion(instance.getResourceVersion());
      this.withResourceVersionMatch(instance.getResourceVersionMatch());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withWatch(instance.getWatch());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ListOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public ListOptions build() {
    ListOptions buildable = new ListOptions(fluent.getAllowWatchBookmarks(),fluent.getApiVersion(),fluent.getContinue(),fluent.getFieldSelector(),fluent.getKind(),fluent.getLabelSelector(),fluent.getLimit(),fluent.getResourceVersion(),fluent.getResourceVersionMatch(),fluent.getTimeoutSeconds(),fluent.getWatch());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}