package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface LoadBalancerIngressFluent<A extends LoadBalancerIngressFluent<A>> extends Fluent<A>{
  public String getHostname();
  public A withHostname(String hostname);
  public Boolean hasHostname();
  public String getIp();
  public A withIp(String ip);
  public Boolean hasIp();
  public A addToPorts(int index,PortStatus item);
  public A setToPorts(int index,PortStatus item);
  public A addToPorts(io.fabric8.kubernetes.api.model.PortStatus... items);
  public A addAllToPorts(Collection<PortStatus> items);
  public A removeFromPorts(io.fabric8.kubernetes.api.model.PortStatus... items);
  public A removeAllFromPorts(Collection<PortStatus> items);
  public A removeMatchingFromPorts(Predicate<PortStatusBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PortStatus> getPorts();
  public List<PortStatus> buildPorts();
  public PortStatus buildPort(int index);
  public PortStatus buildFirstPort();
  public PortStatus buildLastPort();
  public PortStatus buildMatchingPort(Predicate<PortStatusBuilder> predicate);
  public Boolean hasMatchingPort(Predicate<PortStatusBuilder> predicate);
  public A withPorts(List<PortStatus> ports);
  public A withPorts(io.fabric8.kubernetes.api.model.PortStatus... ports);
  public Boolean hasPorts();
  public A addNewPort(String error,Integer port,String protocol);
  public LoadBalancerIngressFluent.PortsNested<A> addNewPort();
  public LoadBalancerIngressFluent.PortsNested<A> addNewPortLike(PortStatus item);
  public LoadBalancerIngressFluent.PortsNested<A> setNewPortLike(int index,PortStatus item);
  public LoadBalancerIngressFluent.PortsNested<A> editPort(int index);
  public LoadBalancerIngressFluent.PortsNested<A> editFirstPort();
  public LoadBalancerIngressFluent.PortsNested<A> editLastPort();
  public LoadBalancerIngressFluent.PortsNested<A> editMatchingPort(Predicate<PortStatusBuilder> predicate);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface PortsNested<N> extends Nested<N>,PortStatusFluent<LoadBalancerIngressFluent.PortsNested<N>>{
    public N and();
    public N endPort();
    
  }
  
}