package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamespaceConditionBuilder extends NamespaceConditionFluentImpl<NamespaceConditionBuilder> implements VisitableBuilder<NamespaceCondition,NamespaceConditionBuilder>{
  public NamespaceConditionBuilder() {
    this(false);
  }
  public NamespaceConditionBuilder(Boolean validationEnabled) {
    this(new NamespaceCondition(), validationEnabled);
  }
  public NamespaceConditionBuilder(NamespaceConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public NamespaceConditionBuilder(NamespaceConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamespaceCondition(), validationEnabled);
  }
  public NamespaceConditionBuilder(NamespaceConditionFluent<?> fluent,NamespaceCondition instance) {
    this(fluent, instance, false);
  }
  public NamespaceConditionBuilder(NamespaceConditionFluent<?> fluent,NamespaceCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamespaceConditionBuilder(NamespaceCondition instance) {
    this(instance,false);
  }
  public NamespaceConditionBuilder(NamespaceCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamespaceConditionFluent<?> fluent;
  Boolean validationEnabled;
  public NamespaceCondition build() {
    NamespaceCondition buildable = new NamespaceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}