package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PhotonPersistentDiskVolumeSourceBuilder extends PhotonPersistentDiskVolumeSourceFluentImpl<PhotonPersistentDiskVolumeSourceBuilder> implements VisitableBuilder<PhotonPersistentDiskVolumeSource,PhotonPersistentDiskVolumeSourceBuilder>{
  public PhotonPersistentDiskVolumeSourceBuilder() {
    this(false);
  }
  public PhotonPersistentDiskVolumeSourceBuilder(Boolean validationEnabled) {
    this(new PhotonPersistentDiskVolumeSource(), validationEnabled);
  }
  public PhotonPersistentDiskVolumeSourceBuilder(PhotonPersistentDiskVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PhotonPersistentDiskVolumeSourceBuilder(PhotonPersistentDiskVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PhotonPersistentDiskVolumeSource(), validationEnabled);
  }
  public PhotonPersistentDiskVolumeSourceBuilder(PhotonPersistentDiskVolumeSourceFluent<?> fluent,PhotonPersistentDiskVolumeSource instance) {
    this(fluent, instance, false);
  }
  public PhotonPersistentDiskVolumeSourceBuilder(PhotonPersistentDiskVolumeSourceFluent<?> fluent,PhotonPersistentDiskVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withPdID(instance.getPdID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PhotonPersistentDiskVolumeSourceBuilder(PhotonPersistentDiskVolumeSource instance) {
    this(instance,false);
  }
  public PhotonPersistentDiskVolumeSourceBuilder(PhotonPersistentDiskVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withPdID(instance.getPdID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PhotonPersistentDiskVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public PhotonPersistentDiskVolumeSource build() {
    PhotonPersistentDiskVolumeSource buildable = new PhotonPersistentDiskVolumeSource(fluent.getFsType(),fluent.getPdID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}