package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PreconditionsBuilder extends PreconditionsFluentImpl<PreconditionsBuilder> implements VisitableBuilder<Preconditions,PreconditionsBuilder>{
  public PreconditionsBuilder() {
    this(false);
  }
  public PreconditionsBuilder(Boolean validationEnabled) {
    this(new Preconditions(), validationEnabled);
  }
  public PreconditionsBuilder(PreconditionsFluent<?> fluent) {
    this(fluent, false);
  }
  public PreconditionsBuilder(PreconditionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Preconditions(), validationEnabled);
  }
  public PreconditionsBuilder(PreconditionsFluent<?> fluent,Preconditions instance) {
    this(fluent, instance, false);
  }
  public PreconditionsBuilder(PreconditionsFluent<?> fluent,Preconditions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withResourceVersion(instance.getResourceVersion());
      fluent.withUid(instance.getUid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PreconditionsBuilder(Preconditions instance) {
    this(instance,false);
  }
  public PreconditionsBuilder(Preconditions instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withResourceVersion(instance.getResourceVersion());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PreconditionsFluent<?> fluent;
  Boolean validationEnabled;
  public Preconditions build() {
    Preconditions buildable = new Preconditions(fluent.getResourceVersion(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}